/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands.runtime.process;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.ProcessInstanceIdCommand;
import org.kie.internal.command.RegistryContext;

@XmlAccessorType(value=XmlAccessType.NONE)
public class StartProcessInstanceCommand
implements ExecutableCommand<ProcessInstance>,
ProcessInstanceIdCommand {
    private static final long serialVersionUID = -270933342071833447L;
    @XmlAttribute(required=true)
    private String processInstanceId;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public StartProcessInstanceCommand() {
    }

    public StartProcessInstanceCommand(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public ProcessInstance execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        ProcessInstance processInstance = ksession.startProcessInstance(this.processInstanceId);
        if (this.outIdentifier != null) {
            ((ExecutionResults)((RegistryContext)context).lookup(ExecutionResults.class)).setResult(this.outIdentifier, (Object)processInstance);
        }
        return processInstance;
    }

    public String toString() {
        return "session.startProcessInstance(" + this.processInstanceId + ");";
    }
}

