/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.dt;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.PortableObject;
import org.drools.guvnor.client.modeldriven.dt.ActionCol;
import org.drools.guvnor.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.guvnor.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.guvnor.client.modeldriven.dt.AttributeCol;
import org.drools.guvnor.client.modeldriven.dt.ConditionCol;
import org.drools.guvnor.client.modeldriven.dt.DTColumnConfig;
import org.drools.guvnor.client.modeldriven.dt.MetadataCol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidedDecisionTable
implements PortableObject {
    public String tableName;
    public String parentName;
    private List<MetadataCol> metadataCols;
    public List<AttributeCol> attributeCols = new ArrayList<AttributeCol>();
    public List<ConditionCol> conditionCols = new ArrayList<ConditionCol>();
    public List<ActionCol> actionCols = new ArrayList<ActionCol>();
    public String[][] data = new String[0][0];
    public int descriptionWidth = -1;
    public String groupField;

    public String[] getValueList(DTColumnConfig col, SuggestionCompletionEngine sce) {
        if (col instanceof AttributeCol) {
            AttributeCol at = (AttributeCol)col;
            if (at.attr.equals("no-loop") || at.attr.equals("enabled")) {
                return new String[]{"true", "false"};
            }
        } else {
            if (col instanceof ConditionCol) {
                ConditionCol c = (ConditionCol)col;
                if (c.constraintValueType == 3 || c.constraintValueType == 5) {
                    return new String[0];
                }
                if (c.valueList != null && !"".equals(c.valueList)) {
                    return c.valueList.split(",");
                }
                String[] r = sce.getEnumValues(c.factType, c.factField);
                return r != null ? r : new String[]{};
            }
            if (col instanceof ActionSetFieldCol) {
                ActionSetFieldCol c = (ActionSetFieldCol)col;
                if (c.valueList != null && !"".equals(c.valueList)) {
                    return c.valueList.split(",");
                }
                String[] r = sce.getEnumValues(this.getBoundFactType(c.boundName), c.factField);
                return r != null ? r : new String[]{};
            }
            if (col instanceof ActionInsertFactCol) {
                ActionInsertFactCol c = (ActionInsertFactCol)col;
                if (c.valueList != null && !"".equals(c.valueList)) {
                    return c.valueList.split(",");
                }
                String[] r = sce.getEnumValues(c.factType, c.factField);
                return r != null ? r : new String[]{};
            }
        }
        return new String[0];
    }

    private String getBoundFactType(String boundName) {
        for (ConditionCol c : this.conditionCols) {
            if (!c.boundName.equals(boundName)) continue;
            return c.factType;
        }
        return null;
    }

    public boolean isNumeric(DTColumnConfig col, SuggestionCompletionEngine sce) {
        if (col instanceof AttributeCol) {
            AttributeCol at = (AttributeCol)col;
            return at.attr.equals("salience");
        }
        if (col instanceof ConditionCol) {
            ConditionCol c = (ConditionCol)col;
            if (c.constraintValueType == 1) {
                if (c.operator == null || "".equals(c.operator)) {
                    return false;
                }
                String ft = sce.getFieldType(c.factType, c.factField);
                if (ft != null && ft.equals("Numeric")) {
                    return true;
                }
            }
        } else if (col instanceof ActionSetFieldCol) {
            ActionSetFieldCol c = (ActionSetFieldCol)col;
            String ft = sce.getFieldType(this.getBoundFactType(c.boundName), c.factField);
            if (ft != null && ft.equals("Numeric")) {
                return true;
            }
        } else if (col instanceof ActionInsertFactCol) {
            ActionInsertFactCol c = (ActionInsertFactCol)col;
            String ft = sce.getFieldType(c.factType, c.factField);
            if (ft != null && ft.equals("Numeric")) {
                return true;
            }
        }
        return false;
    }

    public void setMetadataCols(List<MetadataCol> metadataCols) {
        this.metadataCols = metadataCols;
    }

    public List<MetadataCol> getMetadataCols() {
        if (null == this.metadataCols) {
            this.metadataCols = new ArrayList<MetadataCol>();
        }
        return this.metadataCols;
    }
}

