/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.builder;

import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.Dialect;
import org.drools.compiler.ReturnValueDescr;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.lang.descr.ProcessDescr;
import org.drools.process.builder.ProcessNodeBuilder;
import org.drools.rule.builder.ProcessBuildContext;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.impl.ConstraintImpl;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.instance.impl.ReturnValueConstraintEvaluator;
import org.drools.workflow.instance.impl.RuleConstraintEvaluator;

public class SplitNodeBuilder
implements ProcessNodeBuilder {
    public void build(Process process, ProcessDescr processDescr, ProcessBuildContext context, Node node) {
        Split splitNode = (Split)node;
        if (splitNode.getType() == 1) {
            return;
        }
        HashMap map = new HashMap(splitNode.getConstraints());
        for (Map.Entry entry : map.entrySet()) {
            Split.ConnectionRef connection = (Split.ConnectionRef)entry.getKey();
            ConstraintImpl constraint = (ConstraintImpl)entry.getValue();
            Connection outgoingConnection = null;
            for (Connection out : splitNode.getDefaultOutgoingConnections()) {
                if (!out.getToType().equals(connection.getToType()) || out.getTo().getId() != connection.getNodeId()) continue;
                outgoingConnection = out;
            }
            if (outgoingConnection == null) {
                throw new IllegalArgumentException("Could not find outgoing connection");
            }
            if ("rule".equals(constraint.getType())) {
                RuleConstraintEvaluator ruleConstraint = new RuleConstraintEvaluator();
                ruleConstraint.setDialect(constraint.getDialect());
                ruleConstraint.setName(constraint.getName());
                ruleConstraint.setPriority(constraint.getPriority());
                splitNode.setConstraint(outgoingConnection, (Constraint)ruleConstraint);
                continue;
            }
            if (!"code".equals(constraint.getType())) continue;
            ReturnValueConstraintEvaluator returnValueConstraint = new ReturnValueConstraintEvaluator();
            returnValueConstraint.setDialect(constraint.getDialect());
            returnValueConstraint.setName(constraint.getName());
            returnValueConstraint.setPriority(constraint.getPriority());
            splitNode.setConstraint(outgoingConnection, (Constraint)returnValueConstraint);
            ReturnValueDescr returnValueDescr = new ReturnValueDescr();
            returnValueDescr.setText(constraint.getConstraint());
            Dialect dialect = context.getDialectRegistry().getDialect(constraint.getDialect());
            dialect.getReturnValueEvaluatorBuilder().build(context, returnValueConstraint, returnValueDescr);
        }
    }
}

