/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.drools.base.EnabledBoolean;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.Dialectable;
import org.drools.rule.Package;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.spi.DeclarationScopeResolver;
import org.drools.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBuildContext
extends PackageBuildContext {
    private Rule rule;
    private Stack<RuleConditionElement> buildStack = new Stack();
    private RuleDescr ruleDescr;
    private DeclarationScopeResolver declarationResolver;
    private int patternId = -1;

    public RuleBuildContext(PackageBuilder pkgBuilder, RuleDescr ruleDescr, DialectCompiletimeRegistry dialectCompiletimeRegistry, Package pkg, Dialect defaultDialect) {
        Dialect dialect;
        this.declarationResolver = new DeclarationScopeResolver(new Map[]{pkgBuilder.getGlobals()}, this.buildStack);
        this.declarationResolver.setPackage(pkg);
        this.ruleDescr = ruleDescr;
        this.rule = ruleDescr instanceof QueryDescr ? new Query(ruleDescr.getName()) : new Rule(ruleDescr.getName());
        this.rule.setPackage(pkg.getName());
        RuleBuildContext.setAttributes(this.rule, ruleDescr, ruleDescr.getAttributes());
        this.init(pkgBuilder, pkg, ruleDescr, dialectCompiletimeRegistry, defaultDialect, (Dialectable)this.rule);
        if (this.rule.getDialect() == null) {
            this.rule.setDialect(this.getDialect().getId());
        }
        if ((dialect = this.getDialect()) != null) {
            dialect.init(ruleDescr);
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    public RuleDescr getRuleDescr() {
        return this.ruleDescr;
    }

    public DeclarationScopeResolver getDeclarationResolver() {
        return this.declarationResolver;
    }

    public void setDeclarationResolver(DeclarationScopeResolver variables) {
        this.declarationResolver = variables;
    }

    public int getPatternId() {
        return this.patternId;
    }

    public int getNextPatternId() {
        return ++this.patternId;
    }

    public void setPatternId(int patternId) {
        this.patternId = patternId;
    }

    public Stack<RuleConditionElement> getBuildStack() {
        return this.buildStack;
    }

    public static void setAttributes(Rule rule, RuleDescr ruleDescr, List attributes) {
        for (AttributeDescr attributeDescr : attributes) {
            Calendar cal;
            String name = attributeDescr.getName();
            if (name.equals("salience")) {
                try {
                    ruleDescr.setSalience(attributeDescr.getValue());
                }
                catch (Exception e) {}
                continue;
            }
            if (name.equals("no-loop")) {
                if (attributeDescr.getValue() == null) {
                    rule.setNoLoop(true);
                    continue;
                }
                rule.setNoLoop(Boolean.valueOf(attributeDescr.getValue()).booleanValue());
                continue;
            }
            if (name.equals("auto-focus")) {
                if (attributeDescr.getValue() == null) {
                    rule.setAutoFocus(true);
                    continue;
                }
                rule.setAutoFocus(Boolean.valueOf(attributeDescr.getValue()).booleanValue());
                continue;
            }
            if (name.equals("agenda-group")) {
                rule.setAgendaGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("activation-group")) {
                rule.setActivationGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("ruleflow-group")) {
                rule.setRuleFlowGroup(attributeDescr.getValue());
                continue;
            }
            if (name.equals("lock-on-active")) {
                if (attributeDescr.getValue() == null) {
                    rule.setLockOnActive(true);
                    continue;
                }
                rule.setLockOnActive(Boolean.valueOf(attributeDescr.getValue()).booleanValue());
                continue;
            }
            if (name.equals("duration")) {
                rule.setDuration(Long.parseLong(attributeDescr.getValue()));
                rule.setAgendaGroup("");
                continue;
            }
            if (name.equals("enabled")) {
                if (attributeDescr.getValue() == null || "true".equalsIgnoreCase(attributeDescr.getValue())) {
                    rule.setEnabled(EnabledBoolean.ENABLED_TRUE);
                    continue;
                }
                if (!"false".equalsIgnoreCase(attributeDescr.getValue())) continue;
                rule.setEnabled(EnabledBoolean.ENABLED_FALSE);
                continue;
            }
            if (name.equals("date-effective")) {
                cal = Calendar.getInstance();
                cal.setTime(DateUtils.parseDate((String)attributeDescr.getValue()));
                rule.setDateEffective(cal);
                continue;
            }
            if (name.equals("date-expires")) {
                cal = Calendar.getInstance();
                cal.setTime(DateUtils.parseDate((String)attributeDescr.getValue()));
                rule.setDateExpires(cal);
                continue;
            }
            if (!name.equals("dialect")) continue;
            rule.setDialect(attributeDescr.getValue());
        }
    }
}

