/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.PatternSourceDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternDescr
extends BaseDescr
implements Cloneable {
    private static final long serialVersionUID = 400L;
    private String objectType;
    private String identifier;
    private ConditionalElementDescr constraint = new AndDescr();
    private int leftParentCharacter = -1;
    private int rightParentCharacter = -1;
    private PatternSourceDescr source;
    private List<BehaviorDescr> behaviors;

    public PatternDescr() {
        this(null, null);
    }

    public PatternDescr(String objectType) {
        this(objectType, null);
    }

    public PatternDescr(String objectType, String identifier) {
        this.objectType = objectType;
        this.identifier = identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<? extends BaseDescr> getDescrs() {
        return this.constraint.getDescrs();
    }

    public void addConstraint(BaseDescr base) {
        this.constraint.addDescr(base);
    }

    public ConditionalElementDescr getConstraint() {
        return this.constraint;
    }

    public boolean isInternalFact() {
        return this.getSource() != null && this.getSource() instanceof CollectDescr;
    }

    public String toString() {
        return "[Pattern: id=" + this.identifier + "; objectType=" + this.objectType + "]";
    }

    public int getLeftParentCharacter() {
        return this.leftParentCharacter;
    }

    public void setLeftParentCharacter(int leftParentCharacter) {
        this.leftParentCharacter = leftParentCharacter;
    }

    public int getRightParentCharacter() {
        return this.rightParentCharacter;
    }

    public void setRightParentCharacter(int rightParentCharacter) {
        this.rightParentCharacter = rightParentCharacter;
    }

    public PatternSourceDescr getSource() {
        return this.source;
    }

    public void setSource(PatternSourceDescr source) {
        this.source = source;
    }

    public List<BehaviorDescr> getBehaviors() {
        if (this.behaviors == null) {
            return Collections.emptyList();
        }
        return this.behaviors;
    }

    public void setBehaviors(List<BehaviorDescr> behaviors) {
        this.behaviors = behaviors;
    }

    public void addBehavior(BehaviorDescr behavior) {
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<BehaviorDescr>();
        }
        this.behaviors.add(behavior);
    }

    public Object clone() {
        PatternDescr clone = new PatternDescr(this.objectType, this.identifier);
        clone.setLeftParentCharacter(this.leftParentCharacter);
        clone.setRightParentCharacter(this.rightParentCharacter);
        clone.setSource(this.source);
        clone.setStartCharacter(this.getStartCharacter());
        clone.setEndCharacter(this.getEndCharacter());
        clone.setLocation(this.getLine(), this.getColumn());
        clone.setEndLocation(this.getEndLine(), this.getEndColumn());
        clone.setText(this.getText());
        for (BaseDescr baseDescr : this.getDescrs()) {
            clone.addConstraint(baseDescr);
        }
        if (this.behaviors != null) {
            for (BehaviorDescr behaviorDescr : this.behaviors) {
                clone.addBehavior(behaviorDescr);
            }
        }
        return clone;
    }
}

