/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.guvnor.client.modeldriven.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMethodInspector {
    private final Set<MethodInfo> methods = new HashSet<MethodInfo>();

    public ClassMethodInspector(Class<?> clazz) throws IOException {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method aMethod = methods[i];
            int modifiers = methods[i].getModifiers();
            String methodName = aMethod.getName();
            if (!this.isNotGetterOrSetter(methodName) || !this.isReasonableMethod(clazz, methodName) || !Modifier.isPublic(modifiers)) continue;
            Class<?>[] listParam = aMethod.getParameterTypes();
            MethodInfo info = new MethodInfo(methodName, this.solveParams(listParam));
            this.methods.add(info);
        }
    }

    private boolean isReasonableMethod(Class<?> clazz, String methodName) {
        if ("hashCode".equals(methodName) || "equals".equals(methodName)) {
            return false;
        }
        if (Collection.class.isAssignableFrom(clazz) && this.checkCollectionMethods(methodName)) {
            return false;
        }
        if (Set.class.isAssignableFrom(clazz) && this.checkCollectionMethods(methodName)) {
            return false;
        }
        if (List.class.isAssignableFrom(clazz) && (this.checkCollectionMethods(methodName) || "get".equals(methodName) || "listIterator".equals(methodName) || "lastIndexOf".equals(methodName) || "indexOf".equals(methodName) || "subList".equals(methodName))) {
            return false;
        }
        return !Map.class.isAssignableFrom(clazz) || !"get".equals(methodName) && !"isEmpty".equals(methodName) && !"containsKey".equals(methodName) && !"values".equals(methodName) && !"entrySet".equals(methodName) && !"containsValue".equals(methodName) && !"keySet".equals(methodName) && !"size".equals(methodName);
    }

    private boolean checkCollectionMethods(String methodName) {
        return "toArray".equals(methodName) || "iterator".equals(methodName) || "contains".equals(methodName) || "isEmpty".equals(methodName) || "containsAll".equals(methodName) || "size".equals(methodName);
    }

    private List<String> solveParams(Class<?>[] listParam) {
        ArrayList<String> params = new ArrayList<String>();
        if (listParam.length == 0) {
            return params;
        }
        for (int i = 0; i < listParam.length; ++i) {
            params.add(listParam[i].getName().substring(listParam[i].getName().lastIndexOf(".") + 1));
        }
        return params;
    }

    private boolean isNotGetterOrSetter(String methodName) {
        boolean isGetterOrSetter = methodName.length() > 3 && (methodName.startsWith("set") || methodName.startsWith("get"));
        return !isGetterOrSetter;
    }

    public List<String> getMethodFields(String methodName) {
        ArrayList<String> paramList = new ArrayList<String>();
        for (String string : paramList) {
            paramList.add(string);
        }
        return paramList;
    }

    public List<String> getMethodNames() {
        ArrayList<String> methodList = new ArrayList<String>();
        for (MethodInfo info : this.methods) {
            methodList.add(info.getName());
        }
        return methodList;
    }

    public List<MethodInfo> getMethodInfos() {
        return new ArrayList<MethodInfo>(this.methods);
    }
}

