/*
 * Decompiled with CFR 0.152.
 */
package org.drools.xml.processes;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class RuleFlowMigrator {
    private static final String XSL_RFM_FROM_4_TO_5 = "/org/drools/xml/processes/RuleFlowFrom4To5.xsl";
    private static final String XSL_RF_FROM_4_TO_5 = "/org/drools/xml/processes/RuleFlowGraphicalFrom4To5.xsl";
    private static final String PROCESS_ELEMENT_WITH_NAMESPACE = "<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n";

    public static String portRFToCurrentVersion(String xml) throws Exception {
        return RuleFlowMigrator.portToCurrentVersion(xml, XSL_RF_FROM_4_TO_5);
    }

    public static String portRFMToCurrentVersion(String xml) throws Exception {
        return RuleFlowMigrator.portToCurrentVersion(xml, XSL_RFM_FROM_4_TO_5);
    }

    public static boolean needToMigrateRF(String xml) throws Exception {
        return xml != null && xml.indexOf("org.drools.eclipse.flow.ruleflow.core.RuleFlowProcessWrapper") >= 0;
    }

    public static boolean needToMigrateRFM(String xml) throws Exception {
        return xml != null && xml.indexOf("org.drools.ruleflow.core.impl.RuleFlowProcessImpl") >= 0;
    }

    private static String portToCurrentVersion(String xml, String xsl) throws Exception {
        String version5XML = XSLTransformation.transform(xsl, xml, null);
        version5XML = version5XML.replaceAll("<process ", PROCESS_ELEMENT_WITH_NAMESPACE);
        return version5XML;
    }

    public static String convertReaderToString(Reader reader) throws IOException {
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    public static final void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("usage: RuleFileMigrator source_file dest_file");
                System.exit(1);
            }
            File inFile = new File(args[0]);
            File outFile = new File(args[1]);
            FileReader fr = new FileReader(inFile);
            String xml = RuleFlowMigrator.convertReaderToString(fr);
            String result = null;
            if (RuleFlowMigrator.needToMigrateRF(xml)) {
                result = RuleFlowMigrator.portRFToCurrentVersion(xml);
            }
            if (result != null) {
                System.out.println("Ruleflow migrated from version 4.0 to 5.0");
                FileWriter fw = new FileWriter(outFile);
                fw.write(result);
                fw.flush();
                fw.close();
            } else {
                System.out.println("No Ruleflow Migration Reguired - Ruleflow is version 5.0");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XSLTransformation {
        private XSLTransformation() {
        }

        public static String transform(String stylesheet, String srcXMLString, HashMap<String, String> params) throws Exception {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            StreamSource src = new StreamSource(new StringReader(srcXMLString));
            XSLTransformation.transform(stylesheet, src, result, params);
            return writer.toString();
        }

        public static void transform(String stylesheet, Source src, Result res, HashMap<String, String> params) throws Exception {
            Transformer transformer = XSLTransformation.getTransformer(stylesheet);
            transformer.clearParameters();
            if (params != null && params.size() > 0) {
                for (String key : params.keySet()) {
                    String value = params.get(key);
                    transformer.setParameter(key, value);
                }
            }
            transformer.transform(src, res);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static Transformer getTransformer(String stylesheet) throws Exception {
            Transformer transformer = null;
            BufferedInputStream xslStream = null;
            try {
                InputStream in = XSLTransformation.class.getResourceAsStream(stylesheet);
                xslStream = new BufferedInputStream(in);
                StreamSource src = new StreamSource(xslStream);
                src.setSystemId(stylesheet);
                transformer = TransformerFactory.newInstance().newTransformer(src);
                Object var6_5 = null;
                if (xslStream == null) return transformer;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (xslStream == null) throw throwable;
                ((InputStream)xslStream).close();
                throw throwable;
            }
            ((InputStream)xslStream).close();
            return transformer;
        }
    }
}

