/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.processes;

import java.util.Map;
import org.drools.compiler.xml.XmlDumper;
import org.drools.compiler.xml.processes.AbstractNodeHandler;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.Node;
import org.drools.workflow.core.impl.ConnectionRef;
import org.drools.workflow.core.impl.ExtendedNodeImpl;
import org.drools.workflow.core.node.StateNode;
import org.drools.xml.ExtensibleXmlParser;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class StateNodeHandler
extends AbstractNodeHandler {
    protected Node createNode() {
        return new StateNode();
    }

    public Class generateNodeFor() {
        return StateNode.class;
    }

    public void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StateNode stateNode = (StateNode)node;
        String[] stringArray = stateNode.getActionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String eventType = stringArray[n2];
            this.handleAction((ExtendedNodeImpl)stateNode, element, eventType);
            ++n2;
        }
    }

    public void writeNode(Node node, StringBuilder xmlDump, boolean includeMeta) {
        StateNode stateNode = (StateNode)node;
        this.writeNode("state", (Node)stateNode, xmlDump, includeMeta);
        xmlDump.append(">\n");
        String[] stringArray = stateNode.getActionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String eventType = stringArray[n2];
            this.writeActions(eventType, stateNode.getActions(eventType), xmlDump);
            ++n2;
        }
        this.writeTimers(stateNode.getTimers(), xmlDump);
        if (!stateNode.getConstraints().isEmpty()) {
            xmlDump.append("      <constraints>" + EOL);
            for (Map.Entry entry : stateNode.getConstraints().entrySet()) {
                String constraintString;
                int priority;
                ConnectionRef connection = (ConnectionRef)entry.getKey();
                Constraint constraint = (Constraint)entry.getValue();
                xmlDump.append("        <constraint toNodeId=\"" + connection.getNodeId() + "\" ");
                String name = constraint.getName();
                if (name != null && !"".equals(name)) {
                    xmlDump.append("name=\"" + XmlDumper.replaceIllegalChars(constraint.getName()) + "\" ");
                }
                if ((priority = constraint.getPriority()) != 0) {
                    xmlDump.append("priority=\"" + constraint.getPriority() + "\" ");
                }
                if ((constraintString = constraint.getConstraint()) != null) {
                    xmlDump.append(">" + XmlDumper.replaceIllegalChars(constraintString) + "</constraint>" + EOL);
                    continue;
                }
                xmlDump.append("/>" + EOL);
            }
            xmlDump.append("      </constraints>" + EOL);
        }
        this.endNode("state", xmlDump);
    }
}

