/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Iterator;
import org.drools.core.util.StringUtils;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;

public class JavaRuleClassBuilder
implements RuleClassBuilder {
    public String buildRule(RuleBuildContext context) {
        if (context.getMethods().isEmpty()) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder();
        buffer.append("package " + context.getPkg().getName() + ";" + lineSeparator);
        Iterator<Object> it = context.getPkg().getImports().keySet().iterator();
        while (it.hasNext()) {
            buffer.append("import " + it.next() + ";");
        }
        it = context.getPkg().getStaticImports().iterator();
        while (it.hasNext()) {
            buffer.append("import static " + it.next() + ";");
        }
        buffer.append(lineSeparator);
        RuleDescr ruleDescr = context.getRuleDescr();
        buffer.append("public class " + StringUtils.ucFirst((String)ruleDescr.getClassName()) + " {" + lineSeparator);
        buffer.append("    private static final long serialVersionUID = 400L;" + lineSeparator);
        int i = 0;
        int size = context.getMethods().size() - 1;
        while (i < size) {
            buffer.append(context.getMethods().get(i) + lineSeparator);
            ++i;
        }
        String[] lines = buffer.toString().split(lineSeparator, -1);
        ruleDescr.setConsequenceOffset(lines.length);
        buffer.append(context.getMethods().get(context.getMethods().size() - 1) + lineSeparator);
        buffer.append("}");
        return buffer.toString();
    }
}

