/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.mvel.MVELAction;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.lang.descr.ActionDescr;
import org.drools.process.core.ContextResolver;
import org.drools.process.core.context.variable.VariableScope;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.builder.ActionBuilder;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.spi.Wireable;
import org.drools.workflow.core.DroolsAction;
import org.mvel2.Macro;
import org.mvel2.MacroProcessor;

public class MVELActionBuilder
implements ActionBuilder {
    private static final Map macros = new HashMap(5);

    static {
        macros.put("insert", new Macro(){

            public String doMacro() {
                return "drools.insert";
            }
        });
        macros.put("insertLogical", new Macro(){

            public String doMacro() {
                return "drools.insertLogical";
            }
        });
        macros.put("modify", new Macro(){

            public String doMacro() {
                return "@Modify with";
            }
        });
        macros.put("update", new Macro(){

            public String doMacro() {
                return "drools.update";
            }
        });
        macros.put("retract", new Macro(){

            public String doMacro() {
                return "drools.retract";
            }
        });
    }

    public void build(PackageBuildContext context, DroolsAction action, ActionDescr actionDescr, ContextResolver contextResolver) {
        String text = MVELActionBuilder.processMacros(actionDescr.getText());
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            HashMap variables = new HashMap();
            variables.put("context", ProcessContext.class);
            variables.put("kcontext", org.drools.runtime.process.ProcessContext.class);
            variables.put("drools", KnowledgeHelper.class);
            Dialect.AnalysisResult analysis = dialect.analyzeBlock(context, actionDescr, dialect.getInterceptors(), text, new Map[]{variables, context.getPackageBuilder().getGlobals()}, null);
            List<String> variableNames = analysis.getNotBoundedIdentifiers();
            if (contextResolver != null) {
                for (String variableName : variableNames) {
                    VariableScope variableScope = (VariableScope)contextResolver.resolveContext("VariableScope", (Object)variableName);
                    if (variableScope == null) {
                        context.getErrors().add(new DescrBuildError(context.getParentDescr(), actionDescr, null, "Could not find variable '" + variableName + "' for action '" + actionDescr.getText() + "'"));
                        continue;
                    }
                    variables.put(variableName, context.getDialect().getTypeResolver().resolveType(variableScope.findVariable(variableName).getType().getStringType()));
                }
            }
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, null, null, variables, context);
            MVELAction expr = new MVELAction(unit, context.getDialect().getId());
            expr.setVariableNames(variableNames);
            action.setMetaData("Action", (Object)expr);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(dialect.getId());
            data.addCompileable((Wireable)action, (MVELCompileable)expr);
            expr.compile((ClassLoader)context.getPackageBuilder().getRootClassLoader());
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), actionDescr, null, "Unable to build expression for action '" + actionDescr.getText() + "' :" + e));
        }
    }

    public static String processMacros(String consequence) {
        MacroProcessor macroProcessor = new MacroProcessor();
        macroProcessor.setMacros(macros);
        return macroProcessor.parse(MVELActionBuilder.delimitExpressions(consequence));
    }

    public static String delimitExpressions(String s) {
        StringBuilder result = new StringBuilder();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        int lastNonWhite = 59;
        int i = 0;
        while (i < cs.length) {
            int c = cs[i];
            switch (c) {
                case 40: {
                    ++brace;
                    break;
                }
                case 123: {
                    ++crly;
                    break;
                }
                case 91: {
                    ++sqre;
                    break;
                }
                case 41: {
                    --brace;
                    break;
                }
                case 125: {
                    --crly;
                    break;
                }
                case 93: {
                    --sqre;
                    break;
                }
            }
            if (brace == 0 && sqre == 0 && crly == 0 && (c == 10 || c == 13)) {
                if (lastNonWhite != 59) {
                    result.append(';');
                    lastNonWhite = 59;
                }
            } else if (!Character.isWhitespace((char)c)) {
                lastNonWhite = c;
            }
            result.append((char)c);
            ++i;
        }
        return result.toString();
    }
}

