/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELExprAnalyzer {
    public MVELAnalysisResult analyzeExpression(PackageBuildContext context, String expr, Map<String, Class<?>>[] availableIdentifiers, Map<String, Class<?>> localTypes) {
        MVELAnalysisResult result = null;
        if (expr.trim().length() > 0) {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            ParserConfiguration conf = new ParserConfiguration();
            conf.addAllImports(dialect.getImports());
            if (dialect.getPackgeImports() != null && !dialect.getPackgeImports().isEmpty()) {
                for (String packageImport : dialect.getPackgeImports().values()) {
                    conf.addPackageImport(packageImport);
                }
            }
            conf.setClassLoader((ClassLoader)context.getPackageBuilder().getRootClassLoader());
            ParserContext parserContext1 = new ParserContext(conf);
            parserContext1.setStrictTypeEnforcement(false);
            parserContext1.setInterceptors(dialect.getInterceptors());
            ExpressionCompiler compiler1 = new ExpressionCompiler(expr);
            compiler1.setVerifyOnly(true);
            compiler1.compile(parserContext1);
            Set requiredInputs = compiler1.getParserContextState().getInputs().keySet();
            ParserContext parserContext2 = new ParserContext(conf);
            parserContext2.setStrictTypeEnforcement(false);
            parserContext2.setInterceptors(dialect.getInterceptors());
            Map<String, Class<?>>[] mapArray = availableIdentifiers;
            int n = availableIdentifiers.length;
            int n2 = 0;
            while (n2 < n) {
                Map<String, Class<?>> map = mapArray[n2];
                for (Map.Entry<String, Class<?>> entry : map.entrySet()) {
                    if (!requiredInputs.contains(entry.getKey())) continue;
                    parserContext2.addInput(entry.getKey(), entry.getValue());
                }
                ++n2;
            }
            ExpressionCompiler compiler2 = new ExpressionCompiler(expr);
            compiler2.setVerifyOnly(true);
            compiler2.compile(parserContext2);
            result = this.analyze(compiler2.getParserContextState().getInputs().keySet(), availableIdentifiers);
            result.setMvelVariables(compiler2.getParserContextState().getVariables());
        } else {
            result = this.analyze(Collections.EMPTY_SET, availableIdentifiers);
            result.setMvelVariables(new HashMap());
        }
        return result;
    }

    private MVELAnalysisResult analyze(Set<String> identifiers, Map<String, Class<?>>[] availableIdentifiers) {
        MVELAnalysisResult result = new MVELAnalysisResult();
        result.setIdentifiers(new ArrayList<String>(identifiers));
        HashSet<String> notBound = new HashSet<String>(identifiers);
        List[] used = new List[availableIdentifiers.length];
        int i = 0;
        int length = used.length;
        while (i < length) {
            used[i] = new ArrayList();
            ++i;
        }
        i = 0;
        length = availableIdentifiers.length;
        while (i < length) {
            Set<String> set = availableIdentifiers[i].keySet();
            for (String decl : set) {
                if (!identifiers.contains(decl)) continue;
                used[i].add(decl);
                notBound.remove(decl);
            }
            ++i;
        }
        result.setBoundIdentifiers(used);
        result.setNotBoundedIdentifiers(new ArrayList<String>(notBound));
        return result;
    }
}

