/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.MultiPatternDestinationDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PatternDestinationDescr;
import org.drools.lang.descr.PatternSourceDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccumulateDescr
extends PatternSourceDescr
implements ConditionalElementDescr,
PatternDestinationDescr,
MultiPatternDestinationDescr {
    private static final long serialVersionUID = 510L;
    private BaseDescr input;
    private String initCode;
    private String actionCode;
    private String reverseCode;
    private String resultCode;
    private String[] declarations;
    private String className;
    private List<AccumulateFunctionCallDescr> functions = null;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.input = (BaseDescr)in.readObject();
        this.initCode = (String)in.readObject();
        this.actionCode = (String)in.readObject();
        this.reverseCode = (String)in.readObject();
        this.resultCode = (String)in.readObject();
        this.declarations = (String[])in.readObject();
        this.className = (String)in.readObject();
        this.functions = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.input);
        out.writeObject(this.initCode);
        out.writeObject(this.actionCode);
        out.writeObject(this.reverseCode);
        out.writeObject(this.resultCode);
        out.writeObject(this.declarations);
        out.writeObject(this.className);
        out.writeObject(this.functions);
    }

    @Override
    public int getLine() {
        return this.input.getLine();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String classMethodName) {
        this.className = classMethodName;
    }

    public String[] getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(String[] declarations) {
        this.declarations = declarations;
    }

    public String getActionCode() {
        return this.actionCode;
    }

    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    public String getInitCode() {
        return this.initCode;
    }

    public void setInitCode(String initCode) {
        this.initCode = initCode;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String toString() {
        return "[Accumulate: input=" + this.input.toString() + "]";
    }

    @Override
    public void addDescr(BaseDescr patternDescr) {
        throw new UnsupportedOperationException("Can't add descriptors to " + this.getClass().getName());
    }

    @Override
    public boolean removeDescr(BaseDescr baseDescr) {
        throw new UnsupportedOperationException("Can't remove descriptors from " + this.getClass().getName());
    }

    @Override
    public void insertBeforeLast(Class<?> clazz, BaseDescr baseDescr) {
        throw new UnsupportedOperationException("Can't add descriptors to " + this.getClass().getName());
    }

    public List<BaseDescr> getDescrs() {
        return Collections.emptyList();
    }

    @Override
    public void addOrMerge(BaseDescr baseDescr) {
        throw new UnsupportedOperationException("Can't add descriptors to " + this.getClass().getName());
    }

    public String getReverseCode() {
        return this.reverseCode;
    }

    public void setReverseCode(String reverseCode) {
        this.reverseCode = reverseCode;
    }

    public List<AccumulateFunctionCallDescr> getFunctions() {
        if (this.functions == null) {
            return Collections.emptyList();
        }
        return this.functions;
    }

    public void addFunction(String function, String[] params) {
        this.addFunction(new AccumulateFunctionCallDescr(function, params));
    }

    public void addFunction(AccumulateFunctionCallDescr function) {
        if (this.functions == null) {
            this.functions = new ArrayList<AccumulateFunctionCallDescr>();
        }
        this.functions.add(function);
    }

    public boolean removeFunction(AccumulateFunctionCallDescr function) {
        if (this.functions != null) {
            return this.functions.remove(function);
        }
        return false;
    }

    public boolean isExternalFunction() {
        return this.functions != null && !this.functions.isEmpty();
    }

    @Override
    public PatternDescr getInputPattern() {
        if (this.isSinglePattern()) {
            if (this.input instanceof PatternDescr) {
                return (PatternDescr)this.input;
            }
            return (PatternDescr)((AndDescr)this.input).getDescrs().get(0);
        }
        return null;
    }

    @Override
    public void setInputPattern(PatternDescr inputPattern) {
        this.input = inputPattern;
    }

    @Override
    public BaseDescr getInput() {
        return this.input;
    }

    @Override
    public void setInput(BaseDescr input) {
        this.input = input;
    }

    public boolean isSinglePattern() {
        return this.input instanceof PatternDescr || this.input instanceof AndDescr && ((AndDescr)this.input).getDescrs().size() == 1;
    }

    public boolean isMultiPattern() {
        return !(this.input instanceof PatternDescr);
    }

    public boolean hasValidInput() {
        return this.input != null;
    }

    public static class AccumulateFunctionCallDescr
    implements Serializable {
        private static final long serialVersionUID = 520L;
        private final String function;
        private final String[] params;

        public AccumulateFunctionCallDescr(String function, String[] params) {
            this.function = function;
            this.params = params;
        }

        public String getFunction() {
            return this.function;
        }

        public String[] getParams() {
            return this.params;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
            result = 31 * result + Arrays.hashCode(this.params);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccumulateFunctionCallDescr other = (AccumulateFunctionCallDescr)obj;
            if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
                return false;
            }
            return Arrays.equals(this.params, other.params);
        }
    }
}

