/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.EvaluatorWrapper;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.extractors.MVELClassFieldReader;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.DrlExprParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageRegistry;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.StringUtils;
import org.drools.factmodel.FieldDefinition;
import org.drools.facttemplates.FactTemplate;
import org.drools.facttemplates.FactTemplateFieldExtractor;
import org.drools.facttemplates.FactTemplateObjectType;
import org.drools.lang.DRLLexer;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.AtomicExprDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.OperatorDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.PredicateDescr;
import org.drools.lang.descr.RelationalExprDescr;
import org.drools.lang.descr.ReturnValueRestrictionDescr;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.rule.AbstractCompositeConstraint;
import org.drools.rule.Behavior;
import org.drools.rule.Declaration;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.LiteralRestriction;
import org.drools.rule.MutableTypeConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Query;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.SlidingLengthWindow;
import org.drools.rule.SlidingTimeWindow;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.UnificationRestriction;
import org.drools.rule.VariableConstraint;
import org.drools.rule.VariableRestriction;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.QueryElementBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.AcceptsClassObjectType;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;
import org.drools.spi.PatternExtractor;
import org.drools.spi.Restriction;
import org.drools.time.TimeUtils;
import org.drools.type.DateFormats;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.util.PropertyTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBuilder
implements RuleConditionBuilder {
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        Pattern pattern;
        PatternDescr patternDescr = (PatternDescr)descr;
        if (patternDescr.getObjectType() == null || patternDescr.getObjectType().equals("")) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "ObjectType not correctly defined"));
            return null;
        }
        FactTemplateObjectType objectType = null;
        FactTemplate factTemplate = context.getPkg().getFactTemplate(patternDescr.getObjectType());
        if (factTemplate != null) {
            objectType = new FactTemplateObjectType(factTemplate);
        } else {
            try {
                Class userProvidedClass = context.getDialect().getTypeResolver().resolveType(patternDescr.getObjectType());
                PackageRegistry pkgr = context.getPackageBuilder().getPackageRegistry(ClassUtils.getPackage((Class)userProvidedClass));
                Package pkg = pkgr == null ? context.getPkg() : pkgr.getPackage();
                boolean isEvent = pkg.isEvent(userProvidedClass);
                objectType = new ClassObjectType(userProvidedClass, isEvent);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (objectType == null) {
            RuleConditionElement rce = null;
            if (context.getRule().getName().equals(patternDescr.getObjectType())) {
                QueryElementBuilder qeBuilder = new QueryElementBuilder();
                rce = qeBuilder.build(context, descr, prefixPattern);
            }
            if (rce == null) {
                Rule rule = context.getPkg().getRule(patternDescr.getObjectType());
                if (rule != null && rule instanceof Query) {
                    QueryElementBuilder qeBuilder = new QueryElementBuilder();
                    rce = qeBuilder.build(context, descr, prefixPattern);
                } else {
                    context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "Unable to resolve ObjectType '" + patternDescr.getObjectType() + "'"));
                }
            }
            return rce;
        }
        boolean duplicateBindings = context.getDeclarationResolver().isDuplicated(context.getRule(), patternDescr.getIdentifier());
        if (!StringUtils.isEmpty((CharSequence)patternDescr.getIdentifier()) && !duplicateBindings) {
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, patternDescr.getIdentifier(), patternDescr.isInternalFact());
            if (objectType instanceof ClassObjectType) {
                context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, (AcceptsClassObjectType)((PatternExtractor)pattern.getDeclaration().getExtractor()));
            }
        } else {
            pattern = new Pattern(context.getNextPatternId(), 0, (ObjectType)objectType, null);
        }
        if (duplicateBindings) {
            this.build(context, pattern, new ExprConstraintDescr("this == " + patternDescr.getIdentifier()));
        }
        if (objectType instanceof ClassObjectType) {
            context.getPkg().getClassFieldAccessorStore().getClassObjectType((ClassObjectType)objectType, (AcceptsClassObjectType)pattern);
        }
        context.getBuildStack().push((RuleConditionElement)pattern);
        if (pattern.getObjectType() instanceof ClassObjectType) {
            Class cls = ((ClassObjectType)pattern.getObjectType()).getClassType();
            TypeDeclaration typeDeclr = context.getPackageBuilder().getTypeDeclaration(cls);
            if (typeDeclr != null) {
                context.setTypesafe(typeDeclr.isTypesafe());
            }
        }
        List<BaseDescr> notAConstraints = this.processPositional(patternDescr.getDescrs(), context, patternDescr, pattern);
        for (BaseDescr baseDescr : notAConstraints) {
            patternDescr.removeConstraint(baseDescr);
        }
        Iterator<BaseDescr> i$ = patternDescr.getBindings().iterator();
        while (i$.hasNext()) {
            DrlExprParser parser = new DrlExprParser();
            BindingDescr bindingDescr = (BindingDescr)i$.next();
            String expression = bindingDescr.getExpression();
            ConstraintConnectiveDescr result = parser.parse(expression);
            if (result == null || parser.hasErrors()) {
                for (DroolsParserException error : parser.getErrors()) {
                    context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
                }
                return null;
            }
            String left = parser.getLeftMostExpr();
            if (expression.equals(left)) {
                this.buildRuleBindings(context, pattern, bindingDescr, null);
                continue;
            }
            bindingDescr.setExpression(left);
            this.buildRuleBindings(context, pattern, bindingDescr, null);
            bindingDescr.setExpression(expression);
            this.build(context, pattern, new ExprConstraintDescr(bindingDescr.getExpression()));
        }
        for (BaseDescr baseDescr : patternDescr.getDescrs()) {
            this.build(context, pattern, (ExprConstraintDescr)baseDescr);
        }
        if (patternDescr.getSource() != null) {
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(patternDescr.getSource().getClass());
            PatternSource patternSource = (PatternSource)builder.build(context, patternDescr.getSource());
            pattern.setSource(patternSource);
        }
        for (BehaviorDescr behaviorDescr : patternDescr.getBehaviors()) {
            if (pattern.getObjectType().isEvent()) {
                SlidingTimeWindow window;
                if (Behavior.BehaviorType.TIME_WINDOW.matches(behaviorDescr.getSubType())) {
                    window = new SlidingTimeWindow(TimeUtils.parseTimeString((String)behaviorDescr.getParameters().get(0)));
                    pattern.addBehavior((Behavior)window);
                    continue;
                }
                if (!Behavior.BehaviorType.LENGTH_WINDOW.matches(behaviorDescr.getSubType())) continue;
                window = new SlidingLengthWindow(Integer.valueOf(behaviorDescr.getParameters().get(0)).intValue());
                pattern.addBehavior((Behavior)window);
                continue;
            }
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), patternDescr, null, "A Sliding Window behavior can only be assigned to patterns declared with @role( event ). The pattern '" + pattern.getObjectType() + "' in the rule '" + context.getRule().getName() + "' is not declared as an Event."));
        }
        context.getBuildStack().pop();
        return pattern;
    }

    private List<BaseDescr> processPositional(List<? extends BaseDescr> descrs, RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        LinkedList<BaseDescr> victims = new LinkedList<BaseDescr>();
        for (BaseDescr baseDescr : descrs) {
            ExprConstraintDescr descr = (ExprConstraintDescr)baseDescr;
            if (descr.getType() != ExprConstraintDescr.Type.POSITIONAL || !(pattern.getObjectType() instanceof ClassObjectType)) continue;
            Class klazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
            TypeDeclaration tDecl = context.getPackageBuilder().getTypeDeclaration(klazz);
            if (tDecl == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, klazz, "Unable to find @positional definitions for :" + klazz + "\n"));
                continue;
            }
            FieldDefinition field = tDecl.getTypeClassDef().getField(descr.getPosition());
            if (field == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to find @positional field " + descr.getPosition()) + "\n");
                continue;
            }
            DRLLexer lex = new DRLLexer((CharStream)new ANTLRStringStream(descr.getExpression()));
            boolean isSimpleIdentifier = false;
            try {
                lex.mID();
                isSimpleIdentifier = lex.getCharIndex() >= descr.getExpression().length();
            }
            catch (RecognitionException e) {
                // empty catch block
            }
            if (isSimpleIdentifier) {
                BindingDescr binder = new BindingDescr();
                binder.setExpression(field.getName());
                binder.setVariable(descr.getExpression());
                patternDescr.addBinding(binder);
                victims.add(descr);
                continue;
            }
            descr.setText(field.getName() + " == " + descr.getExpression());
            descr.setType(ExprConstraintDescr.Type.NAMED);
        }
        return victims;
    }

    public void build(RuleBuildContext context, Pattern pattern, ExprConstraintDescr descr) {
        DrlExprParser parser = new DrlExprParser();
        ConstraintConnectiveDescr result = parser.parse(descr.getText());
        if (result == null || parser.hasErrors()) {
            for (DroolsParserException error : parser.getErrors()) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to parser pattern expression:\n" + error.getMessage()));
            }
            return;
        }
        for (BaseDescr d : result.getDescrs()) {
            Pattern thisPattern;
            InternalReadAccessor extractor;
            PredicateDescr pdescr;
            boolean simple = false;
            MVELDumper.MVELDumperContext mvelCtx = new MVELDumper.MVELDumperContext();
            String expr = new MVELDumper().dump(d, mvelCtx);
            Map<String, OperatorDescr> aliases = mvelCtx.getAliases();
            RelationalExprDescr relDescr = null;
            if (d instanceof RelationalExprDescr && (relDescr = (RelationalExprDescr)d).getLeft() instanceof AtomicExprDescr && relDescr.getRight() instanceof AtomicExprDescr) {
                simple = true;
            }
            if (expr.startsWith("eval")) {
                int startParen = expr.indexOf(40) + 1;
                int endParen = expr.lastIndexOf(41);
                expr = expr.substring(startParen, endParen);
                pdescr = new PredicateDescr(expr);
                this.buildEval(context, pattern, pdescr, null, aliases);
                continue;
            }
            if (!simple || !context.isTypesafe()) {
                Dialect dialect = context.getDialect();
                MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
                context.setDialect(mvelDialect);
                pdescr = new PredicateDescr(expr);
                this.buildEval(context, pattern, pdescr, null, aliases);
                context.setDialect(dialect);
                continue;
            }
            if (!(d instanceof RelationalExprDescr)) {
                throw new RuntimeException("What caused this?: " + d);
            }
            RelationalExprDescr exprDescr = (RelationalExprDescr)d;
            AtomicExprDescr rdescr = (AtomicExprDescr)exprDescr.getRight();
            String fieldName = ((AtomicExprDescr)exprDescr.getLeft()).getExpression();
            String value = rdescr.getExpression().trim();
            ExprBindings rightExpr = new ExprBindings();
            this.setInputs(context, rightExpr, pattern.getObjectType() instanceof ClassObjectType ? ((ClassObjectType)pattern.getObjectType()).getClassType() : FactTemplate.class, value);
            String[] parts = fieldName.split("\\.");
            if (parts.length == 2) {
                if ("this".equals(parts[0].trim())) {
                    if (parts[1].trim().startsWith("[")) {
                        Dialect dialect = context.getDialect();
                        MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
                        context.setDialect(mvelDialect);
                        PredicateDescr pdescr2 = new PredicateDescr(expr);
                        this.buildEval(context, pattern, pdescr2, null, aliases);
                        context.setDialect(dialect);
                        continue;
                    }
                    fieldName = parts[1];
                } else if (pattern.getDeclaration() != null && parts[0].trim().equals(pattern.getDeclaration().getIdentifier())) {
                    fieldName = parts[1];
                }
            }
            if (fieldName.indexOf(46) >= 0 || fieldName.indexOf(91) >= 0 || fieldName.indexOf(40) >= 0) {
                ExprBindings leftExpr = new ExprBindings();
                this.setInputs(context, leftExpr, ((ClassObjectType)((Pattern)context.getBuildStack().peek()).getObjectType()).getClassType(), fieldName);
                if (!leftExpr.getRuleBindings().isEmpty()) {
                    Dialect dialect = context.getDialect();
                    MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
                    context.setDialect(mvelDialect);
                    PredicateDescr pdescr3 = new PredicateDescr(expr);
                    this.buildEval(context, pattern, pdescr3, null, aliases);
                    context.setDialect(dialect);
                    continue;
                }
            }
            if ((extractor = PatternBuilder.getFieldReadAccessor(context, d, pattern.getObjectType(), fieldName, null, false)) == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), d, null, "Unable to build constraint as  '" + fieldName + "' is invalid"));
                continue;
            }
            String operator = relDescr.getOperator().trim();
            LiteralRestriction restriction = null;
            if (rdescr.isLiteral()) {
                restriction = this.buildLiteralRestriction(context, extractor, new LiteralRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParameters(), value, 3));
            } else {
                int dotPos = value.indexOf(46);
                if (dotPos >= 0) {
                    String className = value.substring(0, dotPos);
                    String enumName = value.substring(dotPos + 1);
                    try {
                        Class cls = context.getDialect().getTypeResolver().resolveType(className);
                        if (enumName.indexOf(40) < 0 && enumName.indexOf(46) < 0 && enumName.indexOf(91) < 0) {
                            restriction = this.buildLiteralRestriction(context, extractor, new LiteralRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParameters(), value, 3));
                        }
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            if (restriction != null) {
                pattern.addConstraint((Constraint)new LiteralConstraint(extractor, restriction));
                continue;
            }
            Declaration declr = null;
            if (value.indexOf(40) < 0 && value.indexOf(46) < 0 && value.indexOf(91) < 0 && (declr = context.getDeclarationResolver().getDeclaration(context.getRule(), value)) == null && (declr = this.createDeclarationObject(context, value, thisPattern = (Pattern)context.getBuildStack().peek())) == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), d, null, "Unable to return Declaration for identifier '" + value + "'"));
                continue;
            }
            if (declr == null && (parts = value.split("\\.")).length == 2) {
                if ("this".equals(parts[0].trim())) {
                    declr = this.createDeclarationObject(context, parts[1].trim(), (Pattern)context.getBuildStack().peek());
                    value = parts[1].trim();
                } else {
                    declr = context.getDeclarationResolver().getDeclaration(context.getRule(), parts[0].trim());
                    if (declr != null) {
                        if (declr.isPatternDeclaration()) {
                            declr = this.createDeclarationObject(context, parts[1].trim(), declr.getPattern());
                            value = parts[1].trim();
                        } else {
                            context.getErrors().add(new DescrBuildError(context.getParentDescr(), d, "", "Not possible to directly access the property '" + parts[1] + "' of declaration '" + parts[0] + "' since it is not a pattern"));
                            continue;
                        }
                    }
                }
            }
            if (declr != null) {
                EvaluatorDefinition.Target right = this.getRightTarget(extractor);
                EvaluatorDefinition.Target left = declr.isPatternDeclaration() && !Date.class.isAssignableFrom(declr.getExtractor().getExtractToClass()) && !Number.class.isAssignableFrom(declr.getExtractor().getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
                Evaluator evaluator = this.getEvaluator(context, d, extractor.getValueType(), operator, relDescr.isNegated(), relDescr.getParametersText(), left, right);
                if (evaluator == null) continue;
                restriction = new VariableRestriction(extractor, declr, evaluator);
                if (declr.getPattern().getObjectType().equals(new ClassObjectType(DroolsQuery.class))) {
                    restriction = new UnificationRestriction((VariableRestriction)restriction);
                }
            }
            if (restriction == null) {
                Dialect dialect = context.getDialect();
                if (!value.startsWith("(")) {
                    MVELDialect mvelDialect = (MVELDialect)context.getDialect("mvel");
                    context.setDialect(mvelDialect);
                }
                restriction = this.buildRestriction(context, (Pattern)context.getBuildStack().peek(), extractor, new ReturnValueRestrictionDescr(operator, relDescr.isNegated(), relDescr.getParametersText(), value), aliases);
                context.setDialect(dialect);
            }
            if (restriction == null || extractor == null) {
                return;
            }
            pattern.addConstraint((Constraint)new VariableConstraint(extractor, (Restriction)restriction));
        }
    }

    private void setInputs(RuleBuildContext context, ExprBindings descrBranch, Class thisClass, String expr) {
        MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
        ParserConfiguration conf = new ParserConfiguration();
        conf.setImports(dialect.getImports());
        conf.setPackageImports((HashSet)dialect.getPackgeImports());
        conf.setClassLoader((ClassLoader)context.getPackageBuilder().getRootClassLoader());
        ParserContext pctx = new ParserContext(conf);
        pctx.setStrictTypeEnforcement(false);
        pctx.setStrongTyping(false);
        pctx.addInput("this", thisClass);
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.analysisCompile((String)expr, (ParserContext)pctx);
        if (!pctx.getInputs().isEmpty()) {
            for (String v : pctx.getInputs().keySet()) {
                if ("this".equals(v) || PropertyTools.getFieldOrAccessor((Class)thisClass, (String)v) != null) continue;
                if (!context.getPkg().getGlobals().containsKey(v)) {
                    descrBranch.getRuleBindings().add(v);
                    continue;
                }
                descrBranch.getGlobalBindings().add(v);
            }
        }
    }

    private void setConstraintType(Pattern container, MutableTypeConstraint constraint) {
        Declaration[] declarations = constraint.getRequiredDeclarations();
        boolean isAlphaConstraint = true;
        for (int i = 0; isAlphaConstraint && i < declarations.length; ++i) {
            if (declarations[i].isGlobal() || declarations[i].getPattern() == container) continue;
            isAlphaConstraint = false;
        }
        Constraint.ConstraintType type = isAlphaConstraint ? Constraint.ConstraintType.ALPHA : Constraint.ConstraintType.BETA;
        constraint.setType(type);
    }

    private void buildRuleBindings(RuleBuildContext context, Pattern pattern, BindingDescr fieldBindingDescr, AbstractCompositeConstraint container) {
        if (context.getDeclarationResolver().isDuplicated(context.getRule(), fieldBindingDescr.getVariable())) {
            this.build(context, pattern, new ExprConstraintDescr(fieldBindingDescr.getExpression() + " == " + fieldBindingDescr.getVariable()));
            return;
        }
        Declaration declr = pattern.addDeclaration(fieldBindingDescr.getVariable());
        context.addDeclaration(declr);
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, fieldBindingDescr, pattern.getObjectType(), fieldBindingDescr.getExpression(), (AcceptsReadAccessor)declr, true);
        declr.setReadAccessor(extractor);
    }

    private void buildEval(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, AbstractCompositeConstraint container, Map<String, OperatorDescr> aliases) {
        AnalysisResult analysis;
        Map<String, Class<?>> declarations = this.getDeclarationsMap(predicateDescr, context);
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        HashMap<String, EvaluatorWrapper> operators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry<String, OperatorDescr> entry : aliases.entrySet()) {
            Declaration rightDecl;
            OperatorDescr op = entry.getValue();
            String leftStr = op.getLeftString();
            String rightStr = op.getRightString();
            Declaration leftDecl = context.getDeclarationResolver().getDeclaration(context.getRule(), leftStr);
            if (leftDecl == null && "this".equals(leftStr)) {
                leftDecl = this.createDeclarationObject(context, "this", pattern);
            }
            if ((rightDecl = context.getDeclarationResolver().getDeclaration(context.getRule(), rightStr)) == null && "this".equals(rightStr)) {
                rightDecl = this.createDeclarationObject(context, "this", pattern);
            }
            EvaluatorDefinition.Target left = leftDecl != null && leftDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            EvaluatorDefinition.Target right = rightDecl != null && rightDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            op.setLeftIsHandle(left == EvaluatorDefinition.Target.HANDLE);
            op.setRightIsHandle(right == EvaluatorDefinition.Target.HANDLE);
            Evaluator evaluator = this.getEvaluator(context, predicateDescr, ValueType.OBJECT_TYPE, op.getOperator(), false, op.getParametersText(), left, right);
            EvaluatorWrapper wrapper = new EvaluatorWrapper(evaluator, (Declaration)(left == EvaluatorDefinition.Target.HANDLE ? leftDecl : null), (Declaration)(right == EvaluatorDefinition.Target.HANDLE ? rightDecl : null));
            operators.put(entry.getKey(), wrapper);
        }
        Class thisClass = null;
        if (pattern.getObjectType() instanceof ClassObjectType) {
            thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
        }
        if ((analysis = context.getDialect().analyzeExpression(context, predicateDescr, predicateDescr.getContent(), new BoundIdentifiers(declarations, globals, operators, thisClass))) == null) {
            return;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclarations().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        this.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), factDeclarations);
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        String[] requiredOperators = usedIdentifiers.getOperators().keySet().toArray(new String[usedIdentifiers.getOperators().size()]);
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        PredicateConstraint predicateConstraint = new PredicateConstraint(null, previousDeclarations, localDeclarations, requiredGlobals, requiredOperators);
        if (container == null) {
            pattern.addConstraint((Constraint)predicateConstraint);
        } else {
            if (predicateConstraint.getType().equals((Object)Constraint.ConstraintType.UNKNOWN)) {
                this.setConstraintType(pattern, (MutableTypeConstraint)predicateConstraint);
            }
            container.addConstraint((Constraint)predicateConstraint);
        }
        PredicateBuilder builder = context.getDialect().getPredicateBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, predicateConstraint, predicateDescr, analysis);
    }

    private Map<String, Class<?>> getDeclarationsMap(BaseDescr baseDescr, RuleBuildContext context) {
        HashMap declarations = new HashMap();
        for (Map.Entry entry : context.getDeclarationResolver().getDeclarations(context.getRule()).entrySet()) {
            if (((Declaration)entry.getValue()).getExtractor() == null) {
                context.getErrors().add(new DescrBuildError(context.getParentDescr(), baseDescr, null, "Field Reader does not exist for declaration '" + (String)entry.getKey() + "' in'" + baseDescr + "' in the rule '" + context.getRule().getName() + "'"));
                continue;
            }
            declarations.put((String)entry.getKey(), ((Declaration)entry.getValue()).getExtractor().getExtractToClass());
        }
        return declarations;
    }

    private void createImplicitBindings(RuleBuildContext context, Pattern pattern, Set<String> unboundIdentifiers, List factDeclarations) {
        for (String identifier : unboundIdentifiers) {
            Declaration declaration = this.createDeclarationObject(context, identifier, pattern);
            if (declaration == null) continue;
            factDeclarations.add(declaration);
        }
    }

    private Declaration createDeclarationObject(RuleBuildContext context, String identifier, Pattern pattern) {
        return this.createDeclarationObject(context, identifier, identifier, pattern);
    }

    private Declaration createDeclarationObject(RuleBuildContext context, String identifier, String expr, Pattern pattern) {
        BindingDescr implicitBinding = new BindingDescr(identifier, expr);
        Declaration declaration = new Declaration(identifier, null, pattern, true);
        InternalReadAccessor extractor = null;
        if (expr.indexOf(46) >= 0 || expr.indexOf(91) >= 0 || expr.indexOf(40) >= 0) {
            Class classType;
            ObjectType objectType = pattern.getObjectType();
            if (objectType instanceof ClassObjectType) {
                ClassObjectType classObjectType = (ClassObjectType)objectType;
                classType = classObjectType.getClassType();
            } else if (objectType instanceof FactTemplateObjectType) {
                FactTemplateObjectType factTemplateObjectType = (FactTemplateObjectType)objectType;
                String className = factTemplateObjectType.getFactTemplate().getName();
                try {
                    classType = context.getDialect().getTypeResolver().resolveType(className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Can't figure out: " + expr + ", class name: " + className);
                }
            } else {
                throw new RuntimeException("Can't figure out: " + expr);
            }
            extractor = new MVELClassFieldReader(classType, expr, null);
        } else {
            extractor = PatternBuilder.getFieldReadAccessor(context, implicitBinding, pattern.getObjectType(), implicitBinding.getExpression(), (AcceptsReadAccessor)declaration, false);
        }
        if (extractor == null) {
            return null;
        }
        declaration.setReadAccessor(extractor);
        return declaration;
    }

    private LiteralRestriction buildLiteralRestriction(RuleBuildContext context, InternalReadAccessor extractor, LiteralRestrictionDescr literalRestrictionDescr) {
        FieldValue field = null;
        try {
            String value = literalRestrictionDescr.getText().trim();
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            ParserConfiguration pconf = new ParserConfiguration();
            pconf.setImports(dialect.getImports());
            pconf.setPackageImports((HashSet)dialect.getPackgeImports());
            ParserContext pctx = new ParserContext(pconf);
            field = FieldFactory.getFieldValue((Object)MVEL.executeExpression((Object)MVEL.compileExpression((String)value, (ParserContext)pctx)), (ValueType)extractor.getValueType(), (DateFormats)context.getPackageBuilder().getDateFormats());
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), literalRestrictionDescr, e, "Unable to create a Field value of type  '" + extractor.getValueType() + "' and value '" + literalRestrictionDescr.getText() + "'"));
        }
        if (field == null) {
            return null;
        }
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        Evaluator evaluator = this.getEvaluator(context, literalRestrictionDescr, extractor.getValueType(), literalRestrictionDescr.getEvaluator(), literalRestrictionDescr.isNegated(), literalRestrictionDescr.getParameterText(), left, right);
        if (evaluator == null) {
            return null;
        }
        return new LiteralRestriction(field, evaluator, extractor);
    }

    private EvaluatorDefinition.Target getRightTarget(InternalReadAccessor extractor) {
        EvaluatorDefinition.Target right = extractor.isSelfReference() && !Date.class.isAssignableFrom(extractor.getExtractToClass()) && !Number.class.isAssignableFrom(extractor.getExtractToClass()) ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
        return right;
    }

    private ReturnValueRestriction buildRestriction(RuleBuildContext context, Pattern pattern, InternalReadAccessor extractor, ReturnValueRestrictionDescr returnValueRestrictionDescr, Map<String, OperatorDescr> aliases) {
        Map<String, Class<?>> declarations = this.getDeclarationsMap(returnValueRestrictionDescr, context);
        Class thisClass = null;
        if (pattern.getObjectType() instanceof ClassObjectType) {
            thisClass = ((ClassObjectType)pattern.getObjectType()).getClassType();
        }
        Map<String, Class<?>> globals = context.getPackageBuilder().getGlobals();
        AnalysisResult analysis = context.getDialect().analyzeExpression(context, returnValueRestrictionDescr, returnValueRestrictionDescr.getContent(), new BoundIdentifiers(declarations, globals, null, thisClass));
        if (analysis == null) {
            return null;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclarations().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(context.getRule(), id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        this.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), factDeclarations);
        EvaluatorDefinition.Target right = this.getRightTarget(extractor);
        EvaluatorDefinition.Target left = EvaluatorDefinition.Target.FACT;
        Evaluator evaluator = this.getEvaluator(context, returnValueRestrictionDescr, extractor.getValueType(), returnValueRestrictionDescr.getEvaluator(), returnValueRestrictionDescr.isNegated(), returnValueRestrictionDescr.getParameterText(), left, right);
        if (evaluator == null) {
            return null;
        }
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        ReturnValueRestriction returnValueRestriction = new ReturnValueRestriction(extractor, previousDeclarations, localDeclarations, requiredGlobals, evaluator);
        ReturnValueBuilder builder = context.getDialect().getReturnValueBuilder();
        builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, returnValueRestriction, returnValueRestrictionDescr, analysis);
        return returnValueRestriction;
    }

    public static void registerReadAccessor(RuleBuildContext context, ObjectType objectType, String fieldName, AcceptsReadAccessor target) {
        if (!ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
            ClassFieldReader reader = context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
        }
    }

    public static InternalReadAccessor getFieldReadAccessor(RuleBuildContext context, BaseDescr descr, ObjectType objectType, String fieldName, AcceptsReadAccessor target, boolean reportError) {
        ClassFieldReader reader;
        block5: {
            reader = null;
            if (ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
                FactTemplate factTemplate = ((FactTemplateObjectType)objectType).getFactTemplate();
                reader = new FactTemplateFieldExtractor(factTemplate, factTemplate.getFieldTemplateIndex(fieldName));
                if (target != null) {
                    target.setReadAccessor((InternalReadAccessor)reader);
                }
            } else {
                try {
                    reader = context.getPkg().getClassFieldAccessorStore().getReader(((ClassObjectType)objectType).getClassName(), fieldName, target);
                }
                catch (Exception e) {
                    if (!reportError) break block5;
                    context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to create Field Extractor for '" + fieldName + "'"));
                }
            }
        }
        return reader;
    }

    private Evaluator getEvaluator(RuleBuildContext context, BaseDescr descr, ValueType valueType, String evaluatorString, boolean isNegated, String parameters, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        EvaluatorDefinition def = context.getConfiguration().getEvaluatorRegistry().getEvaluatorDefinition(evaluatorString);
        if (def == null) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to determine the Evaluator for ID '" + evaluatorString + "'"));
            return null;
        }
        Evaluator evaluator = def.getEvaluator(valueType, evaluatorString, isNegated, parameters, left, right);
        if (evaluator == null) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Evaluator '" + (isNegated ? "not " : "") + evaluatorString + "' does not support type '" + valueType));
        }
        return evaluator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExprBindings {
        private Set<String> globalBindings = new HashSet<String>();
        private Set<String> ruleBindings = new HashSet<String>();

        public Set<String> getGlobalBindings() {
            return this.globalBindings;
        }

        public Set<String> getRuleBindings() {
            return this.ruleBindings;
        }
    }
}

