/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DroolsError;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Dialectable;
import org.drools.rule.Package;
import org.drools.rule.builder.dialect.mvel.MVELDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageBuildContext {
    private Package pkg;
    private PackageBuilder pkgBuilder;
    private BaseDescr parentDescr;
    private List<DroolsError> errors;
    private List methods;
    private Map<String, String> invokers;
    private Map invokerLookups;
    private Map descrLookups;
    private int counter;
    private DialectCompiletimeRegistry dialectRegistry;
    private Dialect dialect;
    private boolean typesafe;

    public void init(PackageBuilder pkgBuilder, Package pkg, BaseDescr parentDescr, DialectCompiletimeRegistry dialectRegistry, Dialect defaultDialect, Dialectable component) {
        this.pkgBuilder = pkgBuilder;
        this.pkg = pkg;
        this.parentDescr = parentDescr;
        this.methods = new ArrayList();
        this.invokers = new HashMap<String, String>();
        this.invokerLookups = new HashMap();
        this.descrLookups = new HashMap();
        this.errors = new ArrayList<DroolsError>();
        this.dialectRegistry = dialectRegistry;
        this.dialect = component != null && component.getDialect() != null ? this.dialectRegistry.getDialect(component.getDialect()) : defaultDialect;
        this.typesafe = ((MVELDialect)dialectRegistry.getDialect("mvel")).isStrictMode();
        if (this.dialect == null && component != null && component.getDialect() != null) {
            this.errors.add(new DescrBuildError(null, parentDescr, component, "Unable to load Dialect '" + component.getDialect() + "'"));
            this.dialect = defaultDialect;
        }
    }

    public BaseDescr getParentDescr() {
        return this.parentDescr;
    }

    public void setParentDescr(BaseDescr descr) {
        this.parentDescr = descr;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect(String dialectName) {
        return this.dialectRegistry.getDialect(dialectName);
    }

    public DialectCompiletimeRegistry getDialectRegistry() {
        return this.dialectRegistry;
    }

    public List<DroolsError> getErrors() {
        return this.errors;
    }

    public void addError(DroolsError error) {
        this.errors.add(error);
    }

    public Package getPkg() {
        return this.pkg;
    }

    public Map getDescrLookups() {
        return this.descrLookups;
    }

    public void setDescrLookups(Map descrLookups) {
        this.descrLookups = descrLookups;
    }

    public Map getInvokerLookups() {
        return this.invokerLookups;
    }

    public void setInvokerLookups(Map invokerLookups) {
        this.invokerLookups = invokerLookups;
    }

    public Map<String, String> getInvokers() {
        return this.invokers;
    }

    public void setInvokers(Map<String, String> invokers) {
        this.invokers = invokers;
    }

    public List getMethods() {
        return this.methods;
    }

    public void setMethods(List methods) {
        this.methods = methods;
    }

    public int getCurrentId() {
        return this.counter;
    }

    public int getNextId() {
        return this.counter++;
    }

    public PackageBuilderConfiguration getConfiguration() {
        return this.pkgBuilder.getPackageBuilderConfiguration();
    }

    public PackageBuilder getPackageBuilder() {
        return this.pkgBuilder;
    }

    public boolean isTypesafe() {
        return this.typesafe;
    }

    public void setTypesafe(boolean stricttype) {
        this.typesafe = stricttype;
    }
}

