/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.lang.descr.RestrictionDescr;

public class RestrictionConnectiveDescr
extends RestrictionDescr {
    private static final long serialVersionUID = 510L;
    public static final RestrictionConnectiveType AND = RestrictionConnectiveType.AND;
    public static final RestrictionConnectiveType OR = RestrictionConnectiveType.OR;
    private RestrictionConnectiveType connective;
    private List<RestrictionDescr> restrictions;

    public RestrictionConnectiveDescr(RestrictionConnectiveType connective) {
        this.connective = connective;
        this.restrictions = Collections.emptyList();
    }

    public RestrictionConnectiveType getConnective() {
        return this.connective;
    }

    public void addRestriction(RestrictionDescr restriction) {
        if (this.restrictions == Collections.EMPTY_LIST) {
            this.restrictions = new ArrayList<RestrictionDescr>();
        }
        this.restrictions.add(restriction);
    }

    public void addOrMerge(RestrictionDescr restriction) {
        if (restriction instanceof RestrictionConnectiveDescr && ((RestrictionConnectiveDescr)restriction).connective == this.connective) {
            if (this.restrictions == Collections.EMPTY_LIST) {
                this.restrictions = new ArrayList<RestrictionDescr>();
            }
            this.restrictions.addAll(((RestrictionConnectiveDescr)restriction).getRestrictions());
        } else {
            this.addRestriction(restriction);
        }
    }

    public List<RestrictionDescr> getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("( ");
        Iterator<RestrictionDescr> it = this.restrictions.iterator();
        while (it.hasNext()) {
            buf.append(it.next().toString());
            if (!it.hasNext()) continue;
            buf.append(this.connective.toString());
        }
        buf.append("  )");
        return buf.toString();
    }

    public static enum RestrictionConnectiveType {
        AND{

            public String toString() {
                return "&&";
            }
        }
        ,
        OR{

            public String toString() {
                return "||";
            }
        };

    }
}

