/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.IOException;
import java.io.InputStream;
import org.drools.compiler.io.memory.MemoryFileSystem;
import org.drools.core.util.IoUtils;
import org.drools.kproject.models.KieModuleModelImpl;
import org.kie.builder.GAV;
import org.kie.builder.KieFileSystem;
import org.kie.builder.impl.KieBuilderImpl;
import org.kie.io.Resource;

public class KieFileSystemImpl
implements KieFileSystem {
    private final MemoryFileSystem mfs;

    public KieFileSystemImpl() {
        this(new MemoryFileSystem());
    }

    public KieFileSystemImpl(MemoryFileSystem mfs) {
        this.mfs = mfs;
    }

    public KieFileSystem write(String path, byte[] content) {
        this.mfs.write(path, content, true);
        return this;
    }

    public KieFileSystem write(String path, String text) {
        return this.write(path, text.getBytes());
    }

    public KieFileSystem write(String path, Resource resource) {
        try {
            return this.write(path, IoUtils.readBytesFromInputStream((InputStream)resource.getInputStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write Resource: " + resource.toString(), e);
        }
    }

    public void delete(String ... paths) {
        for (String path : paths) {
            this.mfs.remove(path);
        }
    }

    public byte[] read(String path) {
        return this.mfs.read(path);
    }

    public MemoryFileSystem asMemoryFileSystem() {
        return this.mfs;
    }

    public KieFileSystem generateAndWritePomXML(GAV gav) {
        this.write("pom.xml", KieBuilderImpl.generatePomXml(gav));
        return this;
    }

    public KieFileSystem writePomXML(byte[] content) {
        this.write("pom.xml", content);
        return this;
    }

    public KieFileSystem writePomXML(String content) {
        this.write("pom.xml", content);
        return this;
    }

    public KieFileSystem writeKModuleXML(byte[] content) {
        this.write(KieModuleModelImpl.KMODULE_SRC_PATH, content);
        return this;
    }

    public KieFileSystem writeKModuleXML(String content) {
        this.write(KieModuleModelImpl.KMODULE_SRC_PATH, content);
        return this;
    }
}

