/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.drools.io.internal.InternalResource;
import org.drools.kproject.GAVImpl;
import org.drools.kproject.models.KieModuleModelImpl;
import org.kie.builder.GAV;
import org.kie.builder.KieContainer;
import org.kie.builder.KieModule;
import org.kie.builder.KieRepository;
import org.kie.builder.KieScanner;
import org.kie.builder.Results;
import org.kie.builder.impl.ClasspathKieProject;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.InternalKieScanner;
import org.kie.io.Resource;
import org.kie.util.ServiceRegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieRepositoryImpl
implements KieRepository {
    private static final Logger log = LoggerFactory.getLogger(KieRepositoryImpl.class);
    private static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";
    private static final String DEFAULT_ARTIFACT = "artifact";
    private static final String DEFAULT_GROUP = "org.default";
    static final KieRepositoryImpl INSTANCE = new KieRepositoryImpl();
    private final Map<GAV, KieModule> kieModules = new HashMap<GAV, KieModule>();
    private final AtomicReference<GAV> defaultGAV = new AtomicReference<GAVImpl>(new GAVImpl("org.default", "artifact", "1.0.0-SNAPSHOT"));
    private InternalKieScanner internalKieScanner;

    public void setDefaultGAV(GAV gav) {
        this.defaultGAV.set(gav);
    }

    public GAV getDefaultGAV() {
        return this.defaultGAV.get();
    }

    public void addKieModule(KieModule kieModule) {
        this.kieModules.put(kieModule.getGAV(), kieModule);
        log.info("KieModule was added:" + kieModule);
    }

    public Results verfyKieModule(GAV gav) {
        throw new UnsupportedOperationException("org.kie.builder.impl.KieRepositoryImpl.verfyKieModule -> TODO");
    }

    public KieModule getKieModule(GAV gav) {
        KieModule kieModule = this.kieModules.get(gav);
        if (kieModule == null) {
            log.debug("KieModule Lookup. GAV {} was not in cache, checking classpath", (Object)gav.toExternalForm());
            kieModule = this.checkClasspathForKieModule(gav);
        }
        if (kieModule == null) {
            log.debug("KieModule Lookup. GAV {} was not in cache, checking maven repository", (Object)gav.toExternalForm());
            kieModule = this.loadKieModuleFromMavenRepo(gav);
        }
        return kieModule;
    }

    private KieModule checkClasspathForKieModule(GAV gav) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource("((GAVImpl)gav).getPomPropertiesPath()");
        if (url == null) {
            log.debug("KieJar Lookup. GAV {} is not on the classpath", (Object)gav.toExternalForm());
        }
        return null;
    }

    private KieModule loadKieModuleFromMavenRepo(GAV gav) {
        return this.getInternalKieScanner().loadArtifact(gav);
    }

    private InternalKieScanner getInternalKieScanner() {
        if (this.internalKieScanner == null) {
            try {
                this.internalKieScanner = (InternalKieScanner)ServiceRegistryImpl.getInstance().get(KieScanner.class);
            }
            catch (Exception e) {
                this.internalKieScanner = new DummyKieScanner();
            }
        }
        return this.internalKieScanner;
    }

    public KieModule addKieModule(Resource resource, Resource ... dependencies) {
        log.info("Adding KieModule from resource :" + resource);
        KieModule kModule = this.getKieModule(resource);
        if (dependencies != null && dependencies.length > 0) {
            HashMap<GAV, InternalKieModule> list = new HashMap<GAV, InternalKieModule>();
            for (Resource depRes : dependencies) {
                InternalKieModule depKModule = (InternalKieModule)this.getKieModule(depRes);
                log.info("Adding KieModule dependency from resource :" + resource);
                list.put(depKModule.getGAV(), depKModule);
            }
            ((InternalKieModule)kModule).setDependencies(list);
        }
        this.addKieModule(kModule);
        return kModule;
    }

    public KieModule getKieModule(Resource resource) {
        InternalResource res = (InternalResource)resource;
        try {
            String urlPath = res.getURL().toExternalForm();
            if (res.isDirectory()) {
                if (!urlPath.endsWith("/")) {
                    urlPath = urlPath + "/";
                }
                urlPath = urlPath + "META-INF/kproject.xml";
            } else {
                urlPath = "jar:" + urlPath + "!/" + KieModuleModelImpl.KMODULE_JAR_PATH;
            }
            InternalKieModule kModule = ClasspathKieProject.fetchKModule(new URL(urlPath));
            log.debug("fetched KieModule from resource :" + resource);
            return kModule;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to fetch module from resource :" + res, e);
        }
    }

    private static class DummyKieScanner
    implements InternalKieScanner {
        private DummyKieScanner() {
        }

        @Override
        public void setKieContainer(KieContainer kieContainer) {
        }

        @Override
        public KieModule loadArtifact(GAV gav) {
            return null;
        }

        public void start(long pollingInterval) {
        }

        public void stop() {
        }

        public void scanNow() {
        }
    }
}

