/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.drools.lang.descr.AnnotatedBaseDescr;
import org.drools.lang.descr.QualifiedName;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.rule.Namespaceable;
import org.kie.io.Resource;

public abstract class AbstractClassTypeDeclarationDescr
extends AnnotatedBaseDescr
implements Namespaceable {
    private static final long serialVersionUID = 510L;
    private QualifiedName type;
    private Map<String, TypeFieldDescr> fields;

    public AbstractClassTypeDeclarationDescr(String name) {
        this.type = new QualifiedName(name, null);
    }

    public AbstractClassTypeDeclarationDescr(String typeName, String typeNamespace) {
        this.type = new QualifiedName(typeName, typeNamespace);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.type = (QualifiedName)in.readObject();
        this.fields = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.type);
        out.writeObject(this.fields);
    }

    @Override
    public void setNamespace(String namespace) {
        super.setNamespace(namespace);
        this.type.setNamespace(namespace);
    }

    public String getTypeName() {
        return this.type.getName();
    }

    public void setTypeName(String typeName) {
        this.type.setName(typeName);
    }

    public QualifiedName getType() {
        return this.type;
    }

    public void setType(QualifiedName qname) {
        this.type = qname;
    }

    public void setType(String name, String namespace) {
        this.type = new QualifiedName(name, namespace);
    }

    public String getSuperTypeName() {
        return "Object";
    }

    public String getSuperTypeNamespace() {
        return "java.lang";
    }

    public String getSupertTypeFullName() {
        return "java.lang.Object";
    }

    public List<QualifiedName> getSuperTypes() {
        ArrayList<QualifiedName> l = new ArrayList<QualifiedName>(1);
        l.add(new QualifiedName("Object", "java.lang"));
        return l;
    }

    public Map<String, TypeFieldDescr> getFields() {
        return this.fields != null ? this.fields : Collections.emptyMap();
    }

    public void setFields(Map<String, TypeFieldDescr> fields) {
        this.fields = fields;
    }

    public void addField(TypeFieldDescr field) {
        if (this.fields == null) {
            this.fields = new LinkedHashMap<String, TypeFieldDescr>();
        }
        field.setResource(this.getResource());
        this.fields.put(field.getFieldName(), field);
    }

    @Override
    public void setResource(Resource resource) {
        super.setResource(resource);
        if (this.fields != null) {
            for (TypeFieldDescr field : this.fields.values()) {
                field.setResource(resource);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractClassTypeDeclarationDescr that = (AbstractClassTypeDeclarationDescr)o;
        return !(this.getType() == null ? that.getType() != null : !this.getType().equals(that.getType()));
    }

    public int hashCode() {
        return this.getType() != null ? this.getType().hashCode() : 0;
    }
}

