/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.models;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.kproject.models.FileLoggerModelImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.ListenerModelImpl;
import org.drools.compiler.kproject.models.WorkItemHandlerModelImpl;
import org.drools.core.BeliefSystemType;
import org.drools.core.util.AbstractXStreamConverter;
import org.kie.api.builder.model.FileLoggerModel;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.ListenerModel;
import org.kie.api.builder.model.WorkItemHandlerModel;
import org.kie.api.runtime.conf.BeliefSystemTypeOption;
import org.kie.api.runtime.conf.ClockTypeOption;

public class KieSessionModelImpl
implements KieSessionModel {
    private String name;
    private KieSessionModel.KieSessionType type = KieSessionModel.KieSessionType.STATEFUL;
    private ClockTypeOption clockType = ClockTypeOption.get((String)"realtime");
    private BeliefSystemTypeOption beliefSystem = BeliefSystemTypeOption.get((String)BeliefSystemType.SIMPLE.toString());
    private String scope = "javax.enterprise.context.ApplicationScoped";
    private KieBaseModelImpl kBase;
    private final List<ListenerModel> listeners = new ArrayList<ListenerModel>();
    private final List<WorkItemHandlerModel> wihs = new ArrayList<WorkItemHandlerModel>();
    private boolean isDefault = false;
    private String consoleLogger;
    private FileLoggerModel fileLogger;

    private KieSessionModelImpl() {
    }

    public KieSessionModelImpl(KieBaseModelImpl kBase, String name) {
        this.kBase = kBase;
        this.name = name;
    }

    public KieBaseModelImpl getKieBaseModel() {
        return this.kBase;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setKBase(KieBaseModel kieBaseModel) {
        this.kBase = (KieBaseModelImpl)kieBaseModel;
    }

    public KieSessionModel setDefault(boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public KieSessionModel setName(String name) {
        this.kBase.changeKSessionName(this, this.name, name);
        this.name = name;
        return this;
    }

    public KieSessionModel.KieSessionType getType() {
        return this.type;
    }

    public KieSessionModel setType(KieSessionModel.KieSessionType type) {
        this.type = type;
        return this;
    }

    public ClockTypeOption getClockType() {
        return this.clockType;
    }

    public KieSessionModel setClockType(ClockTypeOption clockType) {
        this.clockType = clockType;
        return this;
    }

    public BeliefSystemTypeOption getBeliefSystem() {
        return this.beliefSystem;
    }

    public KieSessionModel setBeliefSystem(BeliefSystemTypeOption beliefSystem) {
        this.beliefSystem = beliefSystem;
        return this;
    }

    public KieSessionModel setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public ListenerModel newListenerModel(String type, ListenerModel.Kind kind) {
        ListenerModelImpl listenerModel = new ListenerModelImpl(this, type, kind);
        this.listeners.add(listenerModel);
        return listenerModel;
    }

    public List<ListenerModel> getListenerModels() {
        return this.listeners;
    }

    private List<ListenerModel> getListenerModels(ListenerModel.Kind kind) {
        ArrayList<ListenerModel> listeners = new ArrayList<ListenerModel>();
        for (ListenerModel listener : this.getListenerModels()) {
            if (listener.getKind() != kind) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    private void addListenerModel(ListenerModel listener) {
        this.listeners.add(listener);
    }

    public WorkItemHandlerModel newWorkItemHandlerModel(String name, String type) {
        WorkItemHandlerModelImpl wihModel = new WorkItemHandlerModelImpl(this, name, type);
        this.wihs.add(wihModel);
        return wihModel;
    }

    public List<WorkItemHandlerModel> getWorkItemHandlerModels() {
        return this.wihs;
    }

    private void addWorkItemHandelerModel(WorkItemHandlerModel wih) {
        this.wihs.add(wih);
    }

    public String getConsoleLogger() {
        return this.consoleLogger;
    }

    public KieSessionModel setConsoleLogger(String consoleLogger) {
        this.consoleLogger = consoleLogger;
        return this;
    }

    public FileLoggerModel getFileLogger() {
        return this.fileLogger;
    }

    public KieSessionModel setFileLogger(String fileName) {
        this.fileLogger = new FileLoggerModelImpl(fileName);
        return this;
    }

    public KieSessionModel setFileLogger(String fileName, int interval, boolean threaded) {
        this.fileLogger = new FileLoggerModelImpl(fileName, interval, threaded);
        return this;
    }

    public String toString() {
        return "KieSessionModel [name=" + this.name + ", clockType=" + this.clockType + "]";
    }

    public static class KSessionConverter
    extends AbstractXStreamConverter {
        public KSessionConverter() {
            super(KieSessionModelImpl.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            KieSessionModelImpl kSession = (KieSessionModelImpl)value;
            writer.addAttribute("name", kSession.getName());
            writer.addAttribute("type", kSession.getType().toString().toLowerCase());
            writer.addAttribute("default", Boolean.toString(kSession.isDefault()));
            if (kSession.getClockType() != null) {
                writer.addAttribute("clockType", kSession.getClockType().getClockType());
            }
            if (kSession.getBeliefSystem() != null) {
                writer.addAttribute("beliefSystem", kSession.getBeliefSystem().getBelieSystemType().toLowerCase());
            }
            if (kSession.getScope() != null) {
                writer.addAttribute("scope", kSession.getScope());
            }
            if (kSession.getConsoleLogger() != null) {
                writer.startNode("consoleLogger");
                if (kSession.getConsoleLogger().length() > 0) {
                    writer.addAttribute("name", kSession.getConsoleLogger());
                }
                writer.endNode();
            }
            if (kSession.getFileLogger() != null) {
                writer.startNode("fileLogger");
                writer.addAttribute("file", kSession.getFileLogger().getFile());
                writer.addAttribute("threaded", "" + kSession.getFileLogger().isThreaded());
                writer.addAttribute("interval", "" + kSession.getFileLogger().getInterval());
                writer.endNode();
            }
            this.writeObjectList(writer, context, "workItemHandlers", "workItemHandler", kSession.getWorkItemHandlerModels());
            if (!kSession.getListenerModels().isEmpty()) {
                writer.startNode("listeners");
                for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.RULE_RUNTIME_EVENT_LISTENER)) {
                    this.writeObject(writer, context, listener.getKind().toString(), listener);
                }
                for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.AGENDA_EVENT_LISTENER)) {
                    this.writeObject(writer, context, listener.getKind().toString(), listener);
                }
                for (ListenerModel listener : kSession.getListenerModels(ListenerModel.Kind.PROCESS_EVENT_LISTENER)) {
                    this.writeObject(writer, context, listener.getKind().toString(), listener);
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
            String scope;
            String beliefSystem;
            final KieSessionModelImpl kSession = new KieSessionModelImpl();
            kSession.name = reader.getAttribute("name");
            kSession.setDefault("true".equals(reader.getAttribute("default")));
            String kSessionType = reader.getAttribute("type");
            kSession.setType(kSessionType != null ? KieSessionModel.KieSessionType.valueOf((String)kSessionType.toUpperCase()) : KieSessionModel.KieSessionType.STATEFUL);
            String clockType = reader.getAttribute("clockType");
            if (clockType != null) {
                kSession.setClockType(ClockTypeOption.get((String)clockType));
            }
            if ((beliefSystem = reader.getAttribute("beliefSystem")) != null) {
                kSession.setBeliefSystem(BeliefSystemTypeOption.get((String)beliefSystem));
            }
            if ((scope = reader.getAttribute("scope")) != null) {
                kSession.setScope(scope);
            }
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    if ("listeners".equals(name)) {
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            String nodeName = reader.getNodeName();
                            ListenerModelImpl listener = (ListenerModelImpl)KSessionConverter.this.readObject(reader, context, ListenerModelImpl.class);
                            listener.setKSession(kSession);
                            listener.setKind(ListenerModel.Kind.fromString((String)nodeName));
                            kSession.addListenerModel(listener);
                            reader.moveUp();
                        }
                    } else if ("workItemHandlers".equals(name)) {
                        List wihs = KSessionConverter.this.readObjectList(reader, context, WorkItemHandlerModelImpl.class);
                        for (WorkItemHandlerModelImpl wih : wihs) {
                            wih.setKSession(kSession);
                            kSession.addWorkItemHandelerModel(wih);
                        }
                    } else if ("consoleLogger".equals(name)) {
                        String consoleLogger = reader.getAttribute("name");
                        kSession.setConsoleLogger(consoleLogger == null ? "" : consoleLogger);
                    } else if ("fileLogger".equals(name)) {
                        FileLoggerModelImpl fileLoggerModel = new FileLoggerModelImpl(reader.getAttribute("file"));
                        try {
                            fileLoggerModel.setInterval(Integer.parseInt(reader.getAttribute("interval")));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            fileLoggerModel.setThreaded(Boolean.parseBoolean(reader.getAttribute("threaded")));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        kSession.fileLogger = fileLoggerModel;
                    }
                }
            });
            return kSession;
        }
    }
}

