/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.rule.builder.AccumulateBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.compiler.rule.builder.util.PackageBuilderUtil;
import org.drools.core.base.accumulators.MVELAccumulatorFunctionExecutor;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.base.mvel.MVELAccumulator;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Wireable;
import org.kie.api.runtime.rule.AccumulateFunction;

public class MVELAccumulateBuilder
implements AccumulateBuilder {
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        boolean typesafe = context.isTypesafe();
        try {
            AccumulateDescr accumDescr = (AccumulateDescr)descr;
            if (!accumDescr.hasValidInput()) {
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(accumDescr.getInput().getClass());
            RuleConditionElement source = builder.build(context, accumDescr.getInput());
            if (source == null) {
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            MVELDialect dialect = (MVELDialect)context.getDialect();
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            Map sourceOuterDeclr = source.getOuterDeclarations();
            HashMap<String, Declaration> mergedDecl = new HashMap<String, Declaration>(decls);
            mergedDecl.putAll(sourceOuterDeclr);
            context.getDeclarationResolver();
            Map declarationClasses = DeclarationScopeResolver.getDeclarationClasses((Map)decls);
            context.getDeclarationResolver();
            declarationClasses.putAll(DeclarationScopeResolver.getDeclarationClasses((Map)sourceOuterDeclr));
            BoundIdentifiers boundIds = new BoundIdentifiers(declarationClasses, context.getKnowledgeBuilder().getGlobals());
            boundIds.setDeclarations(mergedDecl);
            Accumulator[] accumulators = null;
            boolean readLocalsFromTuple = PackageBuilderUtil.isReadLocalsFromTuple(accumDescr, source);
            accumulators = accumDescr.isExternalFunction() ? this.buildExternalFunctions(context, accumDescr, dialect, decls, sourceOuterDeclr, boundIds, readLocalsFromTuple) : this.buildCustomAccumulate(context, accumDescr, source, dialect, decls, sourceOuterDeclr, boundIds, readLocalsFromTuple);
            Accumulate accumulate = new Accumulate(source, null, accumulators, accumDescr.isMultiFunction());
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            int index = 0;
            for (Accumulator accumulator : accumulators) {
                Accumulate accumulate2 = accumulate;
                accumulate2.getClass();
                data.addCompileable((Wireable)new Accumulate.Wirer(accumulate2, index++), (MVELCompileable)accumulator);
                ((MVELCompileable)accumulator).compile(data);
            }
            Accumulate accumulate3 = accumulate;
            return accumulate3;
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, descr);
            context.addError(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to build expression for 'accumulate' : " + e.getMessage()));
            RuleConditionElement ruleConditionElement = null;
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typesafe);
        }
    }

    private Accumulator[] buildExternalFunctions(RuleBuildContext context, AccumulateDescr accumDescr, MVELDialect dialect, Map<String, Declaration> decls, Map<String, Declaration> sourceOuterDeclr, BoundIdentifiers boundIds, boolean readLocalsFromTuple) {
        List<AccumulateDescr.AccumulateFunctionCallDescr> functions = accumDescr.getFunctions();
        Accumulator[] accumulators = new Accumulator[functions.size()];
        SelfReferenceClassFieldReader arrayReader = new SelfReferenceClassFieldReader(Object[].class, "this");
        int index = 0;
        Pattern pattern = (Pattern)context.getBuildStack().peek();
        for (AccumulateDescr.AccumulateFunctionCallDescr func : functions) {
            AccumulateFunction function = context.getConfiguration().getAccumulateFunction(func.getFunction());
            if (function == null) {
                function = (AccumulateFunction)context.getKnowledgeBuilder().getPackage().getAccumulateFunctions().get(func.getFunction());
            }
            if (function == null) {
                context.addError(new DescrBuildError(accumDescr, context.getRuleDescr(), null, "Unknown accumulate function: '" + func.getFunction() + "' on rule '" + context.getRuleDescr().getName() + "'. All accumulate functions must be registered before building a resource."));
                return null;
            }
            if (func.getBind() != null) {
                if (pattern.getDeclaration(func.getBind()) != null) {
                    context.addError(new DescrBuildError(context.getParentDescr(), accumDescr, null, "Duplicate declaration for variable '" + func.getBind() + "' in the rule '" + context.getRule().getName() + "'"));
                } else {
                    this.createResultBind(pattern, index, (InternalReadAccessor)arrayReader, func, function);
                }
            }
            AnalysisResult analysis = dialect.analyzeExpression(context, accumDescr, func.getParams().length > 0 ? func.getParams()[0] : "\"\"", boundIds);
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(func.getParams().length > 0 ? func.getParams()[0] : "\"\"", analysis, this.getUsedDeclarations(decls, analysis), this.getUsedDeclarations(sourceOuterDeclr, analysis), null, context, "drools", KnowledgeHelper.class, readLocalsFromTuple);
            accumulators[index++] = new MVELAccumulatorFunctionExecutor(unit, function);
        }
        return accumulators;
    }

    private Accumulator[] buildCustomAccumulate(RuleBuildContext context, AccumulateDescr accumDescr, RuleConditionElement source, MVELDialect dialect, Map<String, Declaration> decls, Map<String, Declaration> sourceOuterDeclr, BoundIdentifiers boundIds, boolean readLocalsFromTuple) {
        MVELAnalysisResult initCodeAnalysis = (MVELAnalysisResult)dialect.analyzeBlock(context, accumDescr, accumDescr.getInitCode(), boundIds);
        MVELAnalysisResult actionCodeAnalysis = (MVELAnalysisResult)dialect.analyzeBlock(context, accumDescr, null, accumDescr.getActionCode(), boundIds, initCodeAnalysis.getMvelVariables(), "drools", KnowledgeHelper.class);
        MVELAnalysisResult resultCodeAnalysis = (MVELAnalysisResult)dialect.analyzeExpression(context, accumDescr, accumDescr.getResultCode(), boundIds, initCodeAnalysis.getMvelVariables());
        context.setTypesafe(initCodeAnalysis.isTypesafe());
        MVELCompilationUnit initUnit = dialect.getMVELCompilationUnit(accumDescr.getInitCode(), initCodeAnalysis, this.getUsedDeclarations(decls, initCodeAnalysis), this.getUsedDeclarations(sourceOuterDeclr, initCodeAnalysis), initCodeAnalysis.getMvelVariables(), context, "drools", KnowledgeHelper.class, readLocalsFromTuple);
        context.setTypesafe(actionCodeAnalysis.isTypesafe());
        MVELCompilationUnit actionUnit = dialect.getMVELCompilationUnit(accumDescr.getActionCode(), actionCodeAnalysis, this.getUsedDeclarations(decls, actionCodeAnalysis), this.getUsedDeclarations(sourceOuterDeclr, actionCodeAnalysis), initCodeAnalysis.getMvelVariables(), context, "drools", KnowledgeHelper.class, readLocalsFromTuple);
        MVELCompilationUnit reverseUnit = null;
        if (accumDescr.getReverseCode() != null) {
            context.setTypesafe(actionCodeAnalysis.isTypesafe());
            reverseUnit = dialect.getMVELCompilationUnit(accumDescr.getReverseCode(), actionCodeAnalysis, this.getUsedDeclarations(decls, actionCodeAnalysis), this.getUsedDeclarations(sourceOuterDeclr, actionCodeAnalysis), initCodeAnalysis.getMvelVariables(), context, "drools", KnowledgeHelper.class, readLocalsFromTuple);
        }
        context.setTypesafe(resultCodeAnalysis.isTypesafe());
        MVELCompilationUnit resultUnit = dialect.getMVELCompilationUnit(accumDescr.getResultCode(), resultCodeAnalysis, this.getUsedDeclarations(decls, resultCodeAnalysis), this.getUsedDeclarations(sourceOuterDeclr, resultCodeAnalysis), initCodeAnalysis.getMvelVariables(), context, "drools", KnowledgeHelper.class, readLocalsFromTuple);
        Accumulator[] accumulators = new Accumulator[]{new MVELAccumulator(initUnit, actionUnit, reverseUnit, resultUnit)};
        return accumulators;
    }

    private Declaration[] getUsedDeclarations(Map<String, Declaration> decls, AnalysisResult analysis) {
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> usedDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            if (!decls.containsKey(id)) continue;
            usedDeclarations.add(decls.get(id));
        }
        if (!usedDeclarations.isEmpty()) {
            Collections.sort(usedDeclarations, RuleTerminalNode.SortDeclarations.instance);
        }
        return usedDeclarations.toArray(new Declaration[usedDeclarations.size()]);
    }

    private void createResultBind(Pattern pattern, int index, InternalReadAccessor arrayReader, AccumulateDescr.AccumulateFunctionCallDescr fc, AccumulateFunction function) {
        Declaration declr = pattern.addDeclaration(fc.getBind());
        Class type = function.getResultType();
        ArrayElementReader reader = new ArrayElementReader(arrayReader, index, type);
        declr.setReadAccessor((InternalReadAccessor)reader);
    }
}

