/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.drools.compiler.kproject.xml.MinimalPomParser;
import org.drools.compiler.kproject.xml.PomModelGenerator;
import org.kie.api.builder.ReleaseId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PomModel {
    public static final String NATIVE_MAVEN_PARSER_CLASS = "org.kie.scanner.MavenPomModelGenerator";

    public ReleaseId getReleaseId();

    public ReleaseId getParentReleaseId();

    public Collection<ReleaseId> getDependencies();

    public static class DefaultPomModelGenerator
    implements PomModelGenerator {
        @Override
        public PomModel parse(String path, InputStream is) {
            return MinimalPomParser.parse(path, is);
        }
    }

    public static class Parser {
        private static final Logger log = LoggerFactory.getLogger(PomModel.class);

        public static PomModel parse(String path, InputStream is) {
            try {
                return PomModelGeneratorHolder.pomModelGenerator.parse(path, is);
            }
            catch (Exception e) {
                if (PomModelGeneratorHolder.pomModelGenerator.getClass().getName().equals(PomModel.NATIVE_MAVEN_PARSER_CLASS) && Parser.isOpen(is)) {
                    log.warn("Error generated by the maven pom parser, falling back to the internal one", (Throwable)e);
                    return MinimalPomParser.parse(path, is);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        private static boolean isOpen(InputStream is) {
            try {
                return is.available() > 0;
            }
            catch (IOException ioe) {
                return false;
            }
        }

        private static class PomModelGeneratorHolder {
            private static PomModelGenerator pomModelGenerator;

            private PomModelGeneratorHolder() {
            }

            static {
                try {
                    pomModelGenerator = (PomModelGenerator)Class.forName(PomModel.NATIVE_MAVEN_PARSER_CLASS).newInstance();
                }
                catch (Exception e) {
                    pomModelGenerator = new DefaultPomModelGenerator();
                }
            }
        }
    }

    public static class InternalModel
    implements PomModel {
        private ReleaseId releaseId;
        private ReleaseId parentReleaseId;
        private Set<ReleaseId> dependencies = new HashSet<ReleaseId>();

        @Override
        public ReleaseId getReleaseId() {
            return this.releaseId;
        }

        public void setReleaseId(ReleaseId releaseId) {
            this.releaseId = releaseId;
        }

        @Override
        public ReleaseId getParentReleaseId() {
            return this.parentReleaseId;
        }

        public void setParentReleaseId(ReleaseId parentReleaseId) {
            this.parentReleaseId = parentReleaseId;
        }

        @Override
        public Collection<ReleaseId> getDependencies() {
            return this.dependencies;
        }

        public void addDependency(ReleaseId dependency) {
            this.dependencies.add(dependency);
        }
    }
}

