/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.rule.builder.AccumulateBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.DialectUtil;
import org.drools.compiler.rule.builder.dialect.mvel.MVELAnalysisResult;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.compiler.rule.builder.util.PackageBuilderUtil;
import org.drools.core.base.accumulators.MVELAccumulatorFunctionExecutor;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.base.mvel.MVELAccumulator;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.base.mvel.MVELCompileable;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.MultiAccumulate;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.SingleAccumulate;
import org.drools.core.rule.constraint.MvelConstraint;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.MvelAccumulator;
import org.drools.core.spi.Wireable;
import org.drools.core.util.index.IndexUtil;
import org.kie.api.runtime.rule.AccumulateFunction;

public class MVELAccumulateBuilder
implements AccumulateBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, (Pattern)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        boolean typesafe = context.isTypesafe();
        try {
            MultiAccumulate accumulate;
            AccumulateDescr accumDescr = (AccumulateDescr)descr;
            if (!accumDescr.hasValidInput()) {
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(accumDescr.getInput().getClass());
            RuleConditionElement source = builder.build(context, accumDescr.getInput());
            if (source == null) {
                RuleConditionElement ruleConditionElement = null;
                return ruleConditionElement;
            }
            MVELDialect dialect = (MVELDialect)context.getDialect();
            Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
            Map sourceOuterDeclr = source.getOuterDeclarations();
            Map declarationClasses = DeclarationScopeResolver.getDeclarationClasses((Map)decls);
            declarationClasses.putAll(DeclarationScopeResolver.getDeclarationClasses((Map)sourceOuterDeclr));
            BoundIdentifiers boundIds = new BoundIdentifiers(declarationClasses, context);
            boolean readLocalsFromTuple = PackageBuilderUtil.isReadLocalsFromTuple(context, accumDescr, source);
            Accumulator[] accumulators = accumDescr.isExternalFunction() ? this.buildExternalFunctions(context, accumDescr, dialect, decls, sourceOuterDeclr, boundIds, readLocalsFromTuple) : this.buildCustomAccumulate(context, accumDescr, dialect, decls, sourceOuterDeclr, boundIds, readLocalsFromTuple);
            ArrayList requiredDeclarations = new ArrayList();
            for (Accumulator acc : accumulators) {
                MvelAccumulator mvelAcc = (MvelAccumulator)acc;
                Collections.addAll(requiredDeclarations, mvelAcc.getRequiredDeclarations());
            }
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData("mvel");
            if (accumDescr.isMultiFunction()) {
                accumulate = new MultiAccumulate(source, requiredDeclarations.toArray(new Declaration[requiredDeclarations.size()]), accumulators);
                int index = 0;
                for (Accumulator accumulator : accumulators) {
                    MultiAccumulate multiAccumulate = accumulate;
                    multiAccumulate.getClass();
                    data.addCompileable((Wireable)new MultiAccumulate.Wirer(multiAccumulate, index++), (MVELCompileable)accumulator);
                    ((MVELCompileable)accumulator).compile(data, context.getRule());
                }
            } else {
                accumulate = new SingleAccumulate(source, requiredDeclarations.toArray(new Declaration[requiredDeclarations.size()]), accumulators[0]);
                data.addCompileable((Wireable)new SingleAccumulate.Wirer((SingleAccumulate)accumulate), (MVELCompileable)accumulators[0]);
                ((MVELCompileable)accumulators[0]).compile(data, context.getRule());
            }
            MultiAccumulate multiAccumulate = accumulate;
            return multiAccumulate;
        }
        catch (Exception e) {
            DialectUtil.copyErrorLocation(e, descr);
            context.addError(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to build expression for 'accumulate' : " + e.getMessage()));
            RuleConditionElement ruleConditionElement = null;
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typesafe);
        }
    }

    private Accumulator[] buildExternalFunctions(RuleBuildContext context, AccumulateDescr accumDescr, MVELDialect dialect, Map<String, Declaration> decls, Map<String, Declaration> sourceOuterDeclr, BoundIdentifiers boundIds, boolean readLocalsFromTuple) {
        List<AccumulateDescr.AccumulateFunctionCallDescr> functions = accumDescr.getFunctions();
        Accumulator[] accumulators = new Accumulator[functions.size()];
        SelfReferenceClassFieldReader arrayReader = new SelfReferenceClassFieldReader(Object[].class);
        int index = 0;
        Pattern pattern = (Pattern)context.getDeclarationResolver().peekBuildStack();
        for (AccumulateDescr.AccumulateFunctionCallDescr func : functions) {
            AccumulateFunction function = context.getConfiguration().getAccumulateFunction(func.getFunction());
            if (function == null) {
                function = (AccumulateFunction)context.getPkg().getAccumulateFunctions().get(func.getFunction());
            }
            if (function == null) {
                context.addError(new DescrBuildError(accumDescr, context.getRuleDescr(), null, "Unknown accumulate function: '" + func.getFunction() + "' on rule '" + context.getRuleDescr().getName() + "'. All accumulate functions must be registered before building a resource."));
                return null;
            }
            AnalysisResult analysis = dialect.analyzeExpression(context, accumDescr, func.getParams().length > 0 ? func.getParams()[0] : "\"\"", boundIds);
            MVELCompilationUnit unit = MVELDialect.getMVELCompilationUnit(func.getParams().length > 0 ? func.getParams()[0] : "\"\"", analysis, this.getUsedDeclarations(decls, analysis), this.getUsedDeclarations(sourceOuterDeclr, analysis), null, context, "drools", KnowledgeHelper.class, readLocalsFromTuple, MVELCompilationUnit.Scope.CONSTRAINT);
            accumulators[index] = new MVELAccumulatorFunctionExecutor(unit, function);
            if (func.getBind() != null) {
                if (context.getDeclarationResolver().isDuplicated(context.getRule(), func.getBind(), function.getResultType().getName())) {
                    if (!func.isUnification()) {
                        context.addError(new DescrBuildError(context.getParentDescr(), accumDescr, null, "Duplicate declaration for variable '" + func.getBind() + "' in the rule '" + context.getRule().getName() + "'"));
                    } else {
                        Declaration inner = context.getDeclarationResolver().getDeclaration(func.getBind());
                        MvelConstraint c = new MvelConstraint(Collections.singletonList(context.getPkg().getName()), accumDescr.isMultiFunction() ? "this[ " + index + " ] == " + func.getBind() : "this == " + func.getBind(), new Declaration[]{inner}, null, null, IndexUtil.ConstraintType.EQUAL, context.getDeclarationResolver().getDeclaration(func.getBind()), (InternalReadAccessor)(accumDescr.isMultiFunction() ? new ArrayElementReader((InternalReadAccessor)arrayReader, index, function.getResultType()) : new SelfReferenceClassFieldReader(function.getResultType())), true);
                        ((MutableTypeConstraint)c).setType(Constraint.ConstraintType.BETA);
                        pattern.addConstraint((Constraint)c);
                        ++index;
                    }
                } else {
                    Declaration declr = pattern.addDeclaration(func.getBind());
                    if (accumDescr.isMultiFunction()) {
                        declr.setReadAccessor((InternalReadAccessor)new ArrayElementReader((InternalReadAccessor)arrayReader, index, function.getResultType()));
                    } else {
                        declr.setReadAccessor((InternalReadAccessor)new SelfReferenceClassFieldReader(function.getResultType()));
                    }
                }
            }
            ++index;
        }
        return accumulators;
    }

    private Accumulator[] buildCustomAccumulate(RuleBuildContext context, AccumulateDescr accumDescr, MVELDialect dialect, Map<String, Declaration> decls, Map<String, Declaration> sourceOuterDeclr, BoundIdentifiers boundIds, boolean readLocalsFromTuple) {
        MVELAnalysisResult initCodeAnalysis = (MVELAnalysisResult)dialect.analyzeBlock(context, accumDescr, accumDescr.getInitCode(), boundIds);
        MVELAnalysisResult actionCodeAnalysis = (MVELAnalysisResult)dialect.analyzeBlock(context, accumDescr.getActionCode(), boundIds, initCodeAnalysis.getMvelVariables(), "drools", KnowledgeHelper.class);
        MVELAnalysisResult resultCodeAnalysis = (MVELAnalysisResult)MVELDialect.analyzeExpression(context, accumDescr, accumDescr.getResultCode(), boundIds, initCodeAnalysis.getMvelVariables());
        context.setTypesafe(initCodeAnalysis.isTypesafe());
        MVELCompilationUnit initUnit = MVELDialect.getMVELCompilationUnit(accumDescr.getInitCode(), initCodeAnalysis, this.getUsedDeclarations(decls, initCodeAnalysis), this.getUsedDeclarations(sourceOuterDeclr, initCodeAnalysis), initCodeAnalysis.getMvelVariables(), context, "drools", KnowledgeHelper.class, readLocalsFromTuple, MVELCompilationUnit.Scope.CONSTRAINT);
        context.setTypesafe(actionCodeAnalysis.isTypesafe());
        MVELCompilationUnit actionUnit = MVELDialect.getMVELCompilationUnit(accumDescr.getActionCode(), actionCodeAnalysis, this.getUsedDeclarations(decls, actionCodeAnalysis), this.getUsedDeclarations(sourceOuterDeclr, actionCodeAnalysis), initCodeAnalysis.getMvelVariables(), context, "drools", KnowledgeHelper.class, readLocalsFromTuple, MVELCompilationUnit.Scope.CONSTRAINT);
        MVELCompilationUnit reverseUnit = null;
        if (accumDescr.getReverseCode() != null) {
            context.setTypesafe(actionCodeAnalysis.isTypesafe());
            reverseUnit = MVELDialect.getMVELCompilationUnit(accumDescr.getReverseCode(), actionCodeAnalysis, this.getUsedDeclarations(decls, actionCodeAnalysis), this.getUsedDeclarations(sourceOuterDeclr, actionCodeAnalysis), initCodeAnalysis.getMvelVariables(), context, "drools", KnowledgeHelper.class, readLocalsFromTuple, MVELCompilationUnit.Scope.CONSTRAINT);
        }
        context.setTypesafe(resultCodeAnalysis.isTypesafe());
        MVELCompilationUnit resultUnit = MVELDialect.getMVELCompilationUnit(accumDescr.getResultCode(), resultCodeAnalysis, this.getUsedDeclarations(decls, resultCodeAnalysis), this.getUsedDeclarations(sourceOuterDeclr, resultCodeAnalysis), initCodeAnalysis.getMvelVariables(), context, "drools", KnowledgeHelper.class, readLocalsFromTuple, MVELCompilationUnit.Scope.CONSTRAINT);
        Accumulator[] accumulators = new Accumulator[]{new MVELAccumulator(initUnit, actionUnit, reverseUnit, resultUnit)};
        return accumulators;
    }

    private Declaration[] getUsedDeclarations(Map<String, Declaration> decls, AnalysisResult analysis) {
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> usedDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            if (!decls.containsKey(id)) continue;
            usedDeclarations.add(decls.get(id));
        }
        if (!usedDeclarations.isEmpty()) {
            Collections.sort(usedDeclarations, RuleTerminalNode.SortDeclarations.instance);
        }
        return usedDeclarations.toArray(new Declaration[usedDeclarations.size()]);
    }
}

