/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.java;

import java.util.Arrays;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.rule.builder.dialect.java.JavaDialect;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.builder.dialect.asm.ClassLevel;
import org.kie.internal.utils.ChainedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDialectConfiguration
implements DialectConfiguration {
    protected static final transient Logger logger = LoggerFactory.getLogger(JavaDialectConfiguration.class);
    public static final String JAVA_COMPILER_PROPERTY = "drools.dialect.java.compiler";
    public static final String[] LANGUAGE_LEVELS = new String[]{"1.5", "1.6", "1.7", "1.8", "9", "10", "11", "12"};
    private String languageLevel;
    private KnowledgeBuilderConfigurationImpl conf;
    private CompilerType compiler;

    @Override
    public void init(KnowledgeBuilderConfigurationImpl conf) {
        this.conf = conf;
        this.setCompiler(this.getDefaultCompiler());
        this.setJavaLanguageLevel(this.getDefaultLanguageLevel());
    }

    @Override
    public KnowledgeBuilderConfigurationImpl getPackageBuilderConfiguration() {
        return this.conf;
    }

    @Override
    public Dialect newDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        return new JavaDialect(rootClassLoader, pkgConf, pkgRegistry, pkg);
    }

    public String getJavaLanguageLevel() {
        return this.languageLevel;
    }

    public void setJavaLanguageLevel(String languageLevel) {
        if (Arrays.binarySearch(LANGUAGE_LEVELS, languageLevel) < 0) {
            throw new RuntimeException("value '" + languageLevel + "' is not a valid language level");
        }
        this.languageLevel = languageLevel;
    }

    public void setCompiler(CompilerType compiler) {
        if (compiler == CompilerType.ECLIPSE) {
            try {
                Class.forName("org.drools.compiler.shade.org.eclipse.jdt.internal.compiler.Compiler", true, this.conf.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The Eclipse JDT Core jar is not in the classpath");
            }
        }
        if (compiler == CompilerType.JANINO) {
            try {
                Class.forName("org.codehaus.janino.Parser", true, this.conf.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("The Janino jar is not in the classpath");
            }
        }
        switch (compiler) {
            case ECLIPSE: {
                this.compiler = CompilerType.ECLIPSE;
                break;
            }
            case JANINO: {
                this.compiler = CompilerType.JANINO;
                break;
            }
            case NATIVE: {
                this.compiler = CompilerType.NATIVE;
                break;
            }
            default: {
                throw new RuntimeException("value '" + (Object)((Object)compiler) + "' is not a valid compiler");
            }
        }
    }

    public CompilerType getCompiler() {
        return this.compiler;
    }

    private CompilerType getDefaultCompiler() {
        try {
            String prop = this.conf.getChainedProperties().getProperty(JAVA_COMPILER_PROPERTY, "ECLIPSE");
            if (prop.equals("NATIVE")) {
                return CompilerType.NATIVE;
            }
            if (prop.equals("ECLIPSE")) {
                return CompilerType.ECLIPSE;
            }
            if (prop.equals("JANINO")) {
                return CompilerType.JANINO;
            }
            logger.error("Drools config: unable to use the drools.compiler property. Using default. It was set to:" + prop);
            return CompilerType.ECLIPSE;
        }
        catch (SecurityException e) {
            logger.error("Drools config: unable to read the drools.compiler property. Using default.", (Throwable)e);
            return CompilerType.ECLIPSE;
        }
    }

    private String getDefaultLanguageLevel() {
        switch (ClassLevel.findJavaVersion((ChainedProperties)this.conf.getChainedProperties())) {
            case 49: {
                return "1.5";
            }
            case 50: {
                return "1.6";
            }
            case 51: {
                return "1.7";
            }
            case 52: {
                return "1.8";
            }
            case 53: {
                return "9";
            }
            case 54: {
                return "10";
            }
            case 55: {
                return "11";
            }
            case 56: {
                return "12";
            }
        }
        return "1.8";
    }

    public static enum CompilerType {
        ECLIPSE,
        JANINO,
        NATIVE;

    }
}

