/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.appformer.maven.support.AFReleaseId;
import org.appformer.maven.support.DependencyFilter;
import org.appformer.maven.support.PomModel;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.InternalKieModuleProvider;
import org.drools.compiler.kie.builder.impl.KieBaseUpdater;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaterImpl;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaterImplContext;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kie.util.ChangeSetBuilder;
import org.drools.compiler.kie.util.KieJarChangeSet;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.io.internal.InternalResource;
import org.drools.reflective.ResourceProvider;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.definition.KiePackage;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.utils.ClassLoaderResolver;
import org.kie.internal.utils.NoDepsClassLoaderResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface InternalKieModule
extends KieModule,
Serializable {
    public void cacheKnowledgeBuilderForKieBase(String var1, KnowledgeBuilder var2);

    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String var1);

    public Collection<KiePackage> getKnowledgePackagesForKieBase(String var1);

    public InternalKnowledgePackage getPackage(String var1);

    public void cacheResultsForKieBase(String var1, Results var2);

    public Map<String, Results> getKnowledgeResultsCache();

    public KieModuleModel getKieModuleModel();

    public byte[] getBytes();

    public boolean hasResource(String var1);

    public InternalResource getResource(String var1);

    public ResourceConfiguration getResourceConfiguration(String var1);

    public Map<ReleaseId, InternalKieModule> getKieDependencies();

    public void addKieDependency(InternalKieModule var1);

    public Collection<ReleaseId> getJarDependencies(DependencyFilter var1);

    public Collection<ReleaseId> getUnresolvedDependencies();

    public void setUnresolvedDependencies(Collection<ReleaseId> var1);

    public boolean isAvailable(String var1);

    public byte[] getBytes(String var1);

    public Collection<String> getFileNames();

    public File getFile();

    public ResourceProvider createResourceProvider();

    public Map<String, byte[]> getClassesMap();

    public boolean addResourceToCompiler(CompositeKnowledgeBuilder var1, KieBaseModel var2, String var3);

    public boolean addResourceToCompiler(CompositeKnowledgeBuilder var1, KieBaseModel var2, String var3, ResourceChangeSet var4);

    public long getCreationTimestamp();

    public InputStream getPomAsStream();

    public PomModel getPomModel();

    public KnowledgeBuilderConfiguration getBuilderConfiguration(KieBaseModel var1, ClassLoader var2);

    public InternalKnowledgeBase createKieBase(KieBaseModelImpl var1, KieProject var2, ResultsImpl var3, KieBaseConfiguration var4);

    default public void afterKieBaseCreationUpdate(String name, InternalKnowledgeBase kBase) {
    }

    public ClassLoader getModuleClassLoader();

    default public ResultsImpl build() {
        ResultsImpl messages = new ResultsImpl();
        KieBuilderImpl.buildKieModule(this, messages);
        return messages;
    }

    default public KieJarChangeSet getChanges(InternalKieModule newKieModule) {
        return ChangeSetBuilder.build(this, newKieModule);
    }

    default public boolean isFileInKBase(KieBaseModel kieBase, String fileName) {
        return KieBuilderImpl.filterFileInKBase(this, kieBase, fileName, () -> this.getResource(fileName), false);
    }

    default public KieBaseUpdater createKieBaseUpdater(KieBaseUpdaterImplContext context) {
        return new KieBaseUpdaterImpl(context);
    }

    default public ProjectClassLoader createModuleClassLoader(ClassLoader parent) {
        if (parent == null) {
            ClassLoaderResolver resolver = (ClassLoaderResolver)ServiceRegistry.getService(ClassLoaderResolver.class);
            if (resolver == null) {
                resolver = new NoDepsClassLoaderResolver();
            }
            parent = resolver.getClassLoader((KieModule)this);
        }
        return ProjectClassLoader.createProjectClassLoader((ClassLoader)parent, (ResourceProvider)this.createResourceProvider());
    }

    default public CompilationCache getCompilationCache(String kbaseName) {
        return null;
    }

    default public InternalKieModule cloneForIncrementalCompilation(ReleaseId releaseId, KieModuleModel kModuleModel, MemoryFileSystem newFs) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InternalKieModule createKieModule(ReleaseId releaseId, File jar) {
        if (jar.isDirectory()) return null;
        if (!jar.getPath().endsWith(".jar")) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(jar);){
            ZipEntry zipEntry = zipFile.getEntry("META-INF/kmodule.xml");
            if (zipEntry == null) return null;
            InternalKieModule internalKieModule = InternalKieModule.internalCreateKieModule(releaseId, jar, zipFile, zipEntry);
            return internalKieModule;
        }
        catch (MalformedKieModuleException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InternalKieModule internalCreateKieModule(ReleaseId releaseId, File jar, ZipFile zipFile, ZipEntry zipEntry) throws MalformedKieModuleException {
        try (InputStream xmlStream = zipFile.getInputStream(zipEntry);){
            KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML(xmlStream);
            KieBuilderImpl.setDefaultsforEmptyKieModule(kieModuleModel);
            InternalKieModule internalKieModule = kieModuleModel != null ? InternalKieModuleProvider.get(ReleaseIdImpl.adapt((AFReleaseId)releaseId), kieModuleModel, jar) : null;
            return internalKieModule;
        }
        catch (Exception e) {
            throw new MalformedKieModuleException(e);
        }
    }

    default public void updateKieModule(InternalKieModule newKM) {
    }

    public static final class LocalLogger {
        private static final Logger logger = LoggerFactory.getLogger(InternalKieModule.class);
    }

    public static class CompilationCacheEntry
    implements Serializable {
        private static final long serialVersionUID = 1423987159014688588L;
        public final String className;
        public final byte[] bytecode;

        public CompilationCacheEntry(String className, byte[] bytecode) {
            this.className = className;
            this.bytecode = bytecode;
        }
    }

    public static class CompilationCache
    implements Serializable {
        private static final long serialVersionUID = 3812243055974412935L;
        protected final Map<String, Map<String, List<CompilationCacheEntry>>> compilationCache = new HashMap<String, Map<String, List<CompilationCacheEntry>>>();

        public void addEntry(String dialect, String className, byte[] bytecode) {
            String key;
            List<CompilationCacheEntry> bytes;
            Map<String, List<CompilationCacheEntry>> resourceEntries = this.compilationCache.get(dialect);
            if (resourceEntries == null) {
                resourceEntries = new HashMap<String, List<CompilationCacheEntry>>();
                this.compilationCache.put(dialect, resourceEntries);
            }
            if ((bytes = resourceEntries.get(key = className.contains("$") ? className.substring(0, className.indexOf(36)) + ".class" : className)) == null) {
                bytes = new ArrayList<CompilationCacheEntry>();
                resourceEntries.put(key, bytes);
            }
            bytes.add(new CompilationCacheEntry(className, bytecode));
        }

        public Map<String, List<CompilationCacheEntry>> getCacheForDialect(String dialect) {
            return this.compilationCache.get(dialect);
        }
    }

    public static class MalformedKieModuleException
    extends RuntimeException {
        MalformedKieModuleException(Exception cause) {
            super(cause);
        }
    }
}

