/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.compiler.builder.ResourceProcessor;
import org.kie.api.internal.assembler.ProcessedResource;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderError;

public abstract class AbstractResourceProcessor<T extends ProcessedResource>
implements ResourceProcessor<T> {
    private final Resource resource;
    private final ArrayList<KnowledgeBuilderError> errors;
    private T processedResource;

    public AbstractResourceProcessor(Resource resource) {
        this.resource = resource;
        this.errors = new ArrayList();
    }

    @Override
    public abstract void process();

    @Override
    public final Resource getResource() {
        return this.resource;
    }

    protected final void appendError(KnowledgeBuilderError error) {
        this.errors.add(error);
    }

    protected final void setProcessedResource(T processedResource) {
        this.processedResource = processedResource;
    }

    @Override
    public final T getProcessedResource() {
        if (this.processedResource == null && this.errors.isEmpty()) {
            throw new IllegalStateException("Resource has not been processed");
        }
        if (!this.errors.isEmpty()) {
            throw new IllegalStateException("Errors occurred while processing the resource");
        }
        return this.processedResource;
    }

    @Override
    public final Collection<? extends KnowledgeBuilderError> getErrors() {
        return this.errors;
    }
}

