/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.compiler.lang.descr.ConnectiveDescr;
import org.drools.compiler.lang.descr.RestrictionDescr;

public class RestrictionConnectiveDescr
extends RestrictionDescr {
    private static final long serialVersionUID = 510L;
    public static final ConnectiveDescr.RestrictionConnectiveType AND = ConnectiveDescr.RestrictionConnectiveType.AND;
    public static final ConnectiveDescr.RestrictionConnectiveType OR = ConnectiveDescr.RestrictionConnectiveType.OR;
    private ConnectiveDescr.RestrictionConnectiveType connective;
    private List<RestrictionDescr> restrictions;

    public RestrictionConnectiveDescr() {
    }

    public RestrictionConnectiveDescr(ConnectiveDescr.RestrictionConnectiveType connective) {
        this.connective = connective;
        this.restrictions = Collections.emptyList();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.connective = (ConnectiveDescr.RestrictionConnectiveType)((Object)in.readObject());
        this.restrictions = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.connective);
        out.writeObject(this.restrictions);
    }

    public ConnectiveDescr.RestrictionConnectiveType getConnective() {
        return this.connective;
    }

    public void addRestriction(RestrictionDescr restriction) {
        if (this.restrictions == Collections.EMPTY_LIST) {
            this.restrictions = new ArrayList<RestrictionDescr>();
        }
        this.restrictions.add(restriction);
    }

    public void addOrMerge(RestrictionDescr restriction) {
        if (restriction instanceof RestrictionConnectiveDescr && ((RestrictionConnectiveDescr)restriction).connective == this.connective) {
            if (this.restrictions == Collections.EMPTY_LIST) {
                this.restrictions = new ArrayList<RestrictionDescr>();
            }
            this.restrictions.addAll(((RestrictionConnectiveDescr)restriction).getRestrictions());
        } else {
            this.addRestriction(restriction);
        }
    }

    public List<RestrictionDescr> getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("( ");
        Iterator<RestrictionDescr> it = this.restrictions.iterator();
        while (it.hasNext()) {
            buf.append(it.next().toString());
            if (!it.hasNext()) continue;
            buf.append(this.connective.toString());
        }
        buf.append("  )");
        return buf.toString();
    }
}

