/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.base.EvaluatorWrapper;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;

public class BoundIdentifiers {
    private Map<String, Class<?>> declrClasses;
    private Map<String, Class<?>> globals;
    private Map<String, EvaluatorWrapper> operators;
    private Class<?> thisClass;
    private PackageBuildContext context;

    public BoundIdentifiers(Class<?> thisClass) {
        this(Collections.EMPTY_MAP, null, (Map<String, EvaluatorWrapper>)Collections.EMPTY_MAP, thisClass);
    }

    public BoundIdentifiers(Map<String, Class<?>> declarations, PackageBuildContext context) {
        this(declarations, context, (Map<String, EvaluatorWrapper>)Collections.EMPTY_MAP, null);
    }

    public BoundIdentifiers(Map<String, Class<?>> declarations, PackageBuildContext context, Map<String, EvaluatorWrapper> operators) {
        this(declarations, context, operators, null);
    }

    public BoundIdentifiers(Pattern pattern, PackageBuildContext context, Map<String, EvaluatorWrapper> operators, Class<?> thisClass) {
        this(BoundIdentifiers.getDeclarationsMap(pattern, context), context, operators, thisClass);
    }

    public BoundIdentifiers(Map<String, Class<?>> declarations, PackageBuildContext context, Map<String, EvaluatorWrapper> operators, Class<?> thisClass) {
        this.declrClasses = declarations;
        this.context = context;
        this.globals = context != null ? context.getKnowledgeBuilder().getGlobals() : Collections.EMPTY_MAP;
        this.operators = operators;
        this.thisClass = thisClass;
    }

    public PackageBuildContext getContext() {
        return this.context;
    }

    public Map<String, Class<?>> getDeclrClasses() {
        return this.declrClasses;
    }

    public Map<String, Class<?>> getGlobals() {
        return this.globals;
    }

    public void setGlobals(Map<String, Class<?>> globals) {
        this.globals = globals;
    }

    public Map<String, EvaluatorWrapper> getOperators() {
        return this.operators != null ? this.operators : Collections.EMPTY_MAP;
    }

    public Class<?> getThisClass() {
        return this.thisClass;
    }

    public Class<?> resolveType(String identifier) {
        Class<Object> cls = this.declrClasses.get(identifier);
        if (cls == null) {
            cls = this.resolveVarType(identifier);
        }
        if (cls == null && this.operators.containsKey(identifier)) {
            cls = EvaluatorWrapper.class;
        }
        return cls;
    }

    public Class<?> resolveVarType(String identifier) {
        return this.context == null ? null : this.context.resolveVarType(identifier);
    }

    public String toString() {
        return "thisClass: " + this.thisClass + "\n" + "declarations:" + this.declrClasses + "\nglobals:" + this.globals + "\noperators:" + this.operators + "\n";
    }

    private static Map<String, Class<?>> getDeclarationsMap(Pattern pattern, PackageBuildContext context) {
        HashMap declarations = new HashMap();
        if (context instanceof RuleBuildContext) {
            RuleBuildContext ruleContext = (RuleBuildContext)context;
            for (Map.Entry entry : ruleContext.getDeclarationResolver().getDeclarations(ruleContext.getRule()).entrySet()) {
                if (((Declaration)entry.getValue()).getExtractor() == null) continue;
                declarations.put((String)entry.getKey(), ((Declaration)entry.getValue()).getDeclarationClass());
            }
            if (pattern != null) {
                List xpathBackReferenceClasses = pattern.getXpathBackReferenceClasses();
                for (int i = 0; i < xpathBackReferenceClasses.size(); ++i) {
                    declarations.put("$back$ref$" + i, (Class)xpathBackReferenceClasses.get(i));
                }
            }
        }
        return declarations;
    }
}

