/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.ArrayList;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.builder.impl.processors.FilterCondition;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.kie.internal.builder.ResourceChange;

public class ReteCompiler
extends AbstractPackageCompilationPhase {
    private final FilterCondition filter;
    private RuleBase kBase;

    public ReteCompiler(PackageRegistry pkgRegistry, PackageDescr packageDescr, RuleBase kBase, FilterCondition filter) {
        super(pkgRegistry, packageDescr);
        this.kBase = kBase;
        this.filter = filter;
    }

    @Override
    public void process() {
        if (this.kBase != null) {
            InternalKnowledgePackage pkg = this.pkgRegistry.getPackage();
            ArrayList<RuleImpl> rulesToBeAdded = new ArrayList<RuleImpl>();
            for (RuleDescr ruleDescr : this.packageDescr.getRules()) {
                if (!this.filter.accepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName())) continue;
                rulesToBeAdded.add(pkg.getRule(ruleDescr.getName()));
            }
            if (!rulesToBeAdded.isEmpty()) {
                this.kBase.addRules(rulesToBeAdded);
            }
        }
    }
}

