/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.drools.compiler.builder.impl.BuildResultAccumulator;
import org.drools.compiler.compiler.ConfigurableSeverityResult;
import org.drools.compiler.compiler.DroolsErrorWrapper;
import org.drools.compiler.compiler.DroolsWarning;
import org.drools.compiler.compiler.DroolsWarningWrapper;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.compiler.PackageBuilderResults;
import org.drools.drl.parser.BaseKnowledgeBuilderResultImpl;
import org.drools.drl.parser.DroolsError;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResultSeverity;

public class BuildResultAccumulatorImpl
implements BuildResultAccumulator {
    private Collection<KnowledgeBuilderResult> results = new ArrayList<KnowledgeBuilderResult>();

    @Override
    public void addBuilderResult(KnowledgeBuilderResult result) {
        this.results.add(result);
    }

    @Override
    public boolean hasErrors() {
        return !this.getErrorList().isEmpty();
    }

    public Collection<KnowledgeBuilderResult> getInternalResultCollection() {
        return this.results;
    }

    @Override
    public KnowledgeBuilderResults getResults(ResultSeverity ... problemTypes) {
        List<KnowledgeBuilderResult> problems = this.getResultList(problemTypes);
        return new PackageBuilderResults(problems.toArray(new BaseKnowledgeBuilderResultImpl[problems.size()]));
    }

    private List<KnowledgeBuilderResult> getResultList(ResultSeverity ... severities) {
        List<ResultSeverity> typesToFetch = Arrays.asList(severities);
        ArrayList<KnowledgeBuilderResult> problems = new ArrayList<KnowledgeBuilderResult>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (!typesToFetch.contains(problem.getSeverity())) continue;
            problems.add(problem);
        }
        return problems;
    }

    public boolean hasResults(ResultSeverity ... problemTypes) {
        return !this.getResultList(problemTypes).isEmpty();
    }

    private List<DroolsError> getErrorList() {
        ArrayList<DroolsError> errors = new ArrayList<DroolsError>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problem.getSeverity() != ResultSeverity.ERROR) continue;
            if (problem instanceof ConfigurableSeverityResult) {
                errors.add(new DroolsErrorWrapper(problem));
                continue;
            }
            errors.add((DroolsError)problem);
        }
        return errors;
    }

    public boolean hasWarnings() {
        return !this.getWarnings().isEmpty();
    }

    public boolean hasInfo() {
        return !this.getInfoList().isEmpty();
    }

    public List<DroolsWarning> getWarnings() {
        ArrayList<DroolsWarning> warnings = new ArrayList<DroolsWarning>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problem.getSeverity() != ResultSeverity.WARNING) continue;
            if (problem instanceof ConfigurableSeverityResult) {
                warnings.add(new DroolsWarningWrapper(problem));
                continue;
            }
            warnings.add((DroolsWarning)problem);
        }
        return warnings;
    }

    private List<KnowledgeBuilderResult> getInfoList() {
        return this.getResultList(ResultSeverity.INFO);
    }

    public void reportError(KnowledgeBuilderError error) {
        this.getErrors().add(error);
    }

    public PackageBuilderErrors getErrors() {
        List<DroolsError> errors = this.getErrorList();
        return new PackageBuilderErrors(errors.toArray(new DroolsError[errors.size()]));
    }

    public void resetErrors() {
        this.resetProblemType(ResultSeverity.ERROR);
    }

    public void resetWarnings() {
        this.resetProblemType(ResultSeverity.WARNING);
    }

    private void resetProblemType(ResultSeverity problemType) {
        ArrayList<KnowledgeBuilderResult> toBeDeleted = new ArrayList<KnowledgeBuilderResult>();
        for (KnowledgeBuilderResult problem : this.results) {
            if (problemType == null || !problemType.equals((Object)problem.getSeverity())) continue;
            toBeDeleted.add(problem);
        }
        this.results.removeAll(toBeDeleted);
    }

    public void resetProblems() {
        this.results.clear();
    }

    public void addAll(Collection<? extends KnowledgeBuilderResult> results) {
        this.results.addAll(results);
    }
}

