/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Stream;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.RuleBuildError;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleBuilder;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.util.StringUtils;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResourceChange;

public class RuleCompiler
extends AbstractPackageCompilationPhase {
    private InternalKnowledgeBase kBase;
    private int parallelRulesBuildThreshold;
    private final KnowledgeBuilderImpl.AssetFilter assetFilter;
    private final Map<String, AttributeDescr> packageAttributes;
    private final Resource resource;
    private final DroolsAssemblerContext kBuilder;

    public RuleCompiler(PackageRegistry pkgRegistry, PackageDescr packageDescr, InternalKnowledgeBase kBase, int parallelRulesBuildThreshold, KnowledgeBuilderImpl.AssetFilter assetFilter, Map<String, AttributeDescr> packageAttributes, Resource resource, DroolsAssemblerContext kBuilder) {
        super(pkgRegistry, packageDescr);
        this.kBase = kBase;
        this.parallelRulesBuildThreshold = parallelRulesBuildThreshold;
        this.assetFilter = assetFilter;
        this.packageAttributes = packageAttributes;
        this.resource = resource;
        this.kBuilder = kBuilder;
    }

    @Override
    public void process() {
        this.preProcessRules(this.packageDescr, this.pkgRegistry);
        SortedRules sortedRules = this.sortRulesByDependency(this.packageDescr, this.pkgRegistry);
        if (!sortedRules.queries.isEmpty()) {
            this.compileAllQueries(this.packageDescr, this.pkgRegistry, sortedRules.queries);
        }
        for (List<RuleDescr> rulesLevel : sortedRules.rules) {
            this.compileRulesLevel(this.packageDescr, this.pkgRegistry, rulesLevel);
        }
    }

    private void preProcessRules(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        if (this.kBase == null) {
            return;
        }
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        boolean needsRemoval = false;
        for (Rule rule : pkg.getRules()) {
            if (!this.filterAcceptsRemoval(ResourceChange.Type.RULE, rule.getPackageName(), rule.getName())) continue;
            needsRemoval = true;
            break;
        }
        if (!needsRemoval) {
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName()) || pkg.getRule(ruleDescr.getName()) == null) continue;
                needsRemoval = true;
                break;
            }
        }
        if (needsRemoval) {
            this.kBase.enqueueModification(() -> {
                HashSet<RuleImpl> rulesToBeRemoved = new HashSet<RuleImpl>();
                for (Rule rule : pkg.getRules()) {
                    if (!this.filterAcceptsRemoval(ResourceChange.Type.RULE, rule.getPackageName(), rule.getName())) continue;
                    rulesToBeRemoved.add((RuleImpl)rule);
                }
                rulesToBeRemoved.forEach(arg_0 -> ((InternalKnowledgePackage)pkg).removeRule(arg_0));
                for (RuleDescr ruleDescr : packageDescr.getRules()) {
                    RuleImpl rule;
                    if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName()) || (rule = pkg.getRule(ruleDescr.getName())) == null) continue;
                    rulesToBeRemoved.add(rule);
                }
                if (!rulesToBeRemoved.isEmpty()) {
                    rulesToBeRemoved.addAll(this.findChildrenRulesToBeRemoved(packageDescr, rulesToBeRemoved));
                    this.kBase.removeRules(rulesToBeRemoved);
                }
            });
        }
    }

    private boolean filterAccepts(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter == null || !KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING.equals((Object)this.assetFilter.accept(type, namespace, name));
    }

    private boolean filterAcceptsRemoval(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter != null && KnowledgeBuilderImpl.AssetFilter.Action.REMOVE.equals((Object)this.assetFilter.accept(type, namespace, name));
    }

    private SortedRules sortRulesByDependency(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        ArrayList<RuleDescr> roots = new ArrayList<RuleDescr>();
        HashMap<String, List<RuleDescr>> children = new HashMap<String, List<RuleDescr>>();
        LinkedHashMap<String, RuleDescr> sorted = new LinkedHashMap<String, RuleDescr>();
        ArrayList<RuleDescr> queries = new ArrayList<RuleDescr>();
        HashSet<String> compiledRules = new HashSet<String>();
        for (Object ruleDescr : packageDescr.getRules()) {
            if (ruleDescr.isQuery()) {
                queries.add((RuleDescr)ruleDescr);
                continue;
            }
            if (!ruleDescr.hasParent()) {
                roots.add((RuleDescr)ruleDescr);
                continue;
            }
            if (pkg.getRule(ruleDescr.getParentName()) != null) {
                compiledRules.add(ruleDescr.getParentName());
            }
            children.computeIfAbsent(ruleDescr.getParentName(), k -> new ArrayList()).add(ruleDescr);
        }
        SortedRules sortedRules = new SortedRules();
        sortedRules.queries = queries;
        if (children.isEmpty()) {
            if (!queries.isEmpty()) {
                packageDescr.getRules().removeAll(queries);
                packageDescr.getRules().addAll(0, queries);
                sortedRules.rules.add(packageDescr.getRules().subList(queries.size(), packageDescr.getRules().size()));
            } else {
                sortedRules.rules.add(packageDescr.getRules());
            }
            return sortedRules;
        }
        for (String compiledRule : compiledRules) {
            List childz = (List)children.remove(compiledRule);
            roots.addAll(childz);
        }
        List<RuleDescr> rulesLevel = roots;
        while (!rulesLevel.isEmpty()) {
            rulesLevel = this.sortRulesLevel(rulesLevel, sorted, sortedRules, children);
            sortedRules.newLevel();
        }
        this.reportHierarchyErrors(children, sorted);
        packageDescr.getRules().clear();
        packageDescr.getRules().addAll(queries);
        for (RuleDescr descr : sorted.values()) {
            packageDescr.getRules().add(descr);
        }
        return sortedRules;
    }

    private List<RuleDescr> sortRulesLevel(List<RuleDescr> rulesLevel, LinkedHashMap<String, RuleDescr> sorted, SortedRules sortedRules, Map<String, List<RuleDescr>> children) {
        ArrayList<RuleDescr> nextLevel = new ArrayList<RuleDescr>();
        rulesLevel.forEach(ruleDescr -> {
            sortedRules.addRule((RuleDescr)ruleDescr);
            sorted.put(ruleDescr.getName(), (RuleDescr)ruleDescr);
            List childz = (List)children.remove(ruleDescr.getName());
            if (childz != null) {
                nextLevel.addAll(childz);
            }
        });
        return nextLevel;
    }

    private void reportHierarchyErrors(Map<String, List<RuleDescr>> parents, Map<String, RuleDescr> sorted) {
        boolean circularDep = false;
        for (List<RuleDescr> rds : parents.values()) {
            for (RuleDescr ruleDescr : rds) {
                if (parents.get(ruleDescr.getParentName()) != null && (sorted.containsKey(ruleDescr.getName()) || parents.containsKey(ruleDescr.getName()))) {
                    circularDep = true;
                    this.results.add(new RuleBuildError(RuleBuildContext.descrToRule(ruleDescr), (BaseDescr)ruleDescr, null, "Circular dependency in rules hierarchy"));
                    break;
                }
                this.manageUnresolvedExtension(ruleDescr, sorted.values());
            }
            if (!circularDep) continue;
            break;
        }
    }

    private void manageUnresolvedExtension(RuleDescr ruleDescr, Collection<RuleDescr> candidates) {
        ArrayList<String> candidateRules = new ArrayList<String>();
        for (RuleDescr r : candidates) {
            if (!(StringUtils.stringSimilarity((String)ruleDescr.getParentName(), (String)r.getName(), (StringUtils.SIMILARITY_STRATS)StringUtils.SIMILARITY_STRATS.DICE) >= 0.75)) continue;
            candidateRules.add(r.getName());
        }
        String msg = "Unresolved parent name " + ruleDescr.getParentName();
        if (!candidateRules.isEmpty()) {
            msg = msg + " >> did you mean any of :" + candidateRules;
        }
        this.results.add(new RuleBuildError(RuleBuildContext.descrToRule(ruleDescr), (BaseDescr)ruleDescr, (Object)msg, "Unable to resolve parent rule, please check that both rules are in the same package"));
    }

    private void compileAllQueries(PackageDescr packageDescr, PackageRegistry pkgRegistry, List<RuleDescr> rules) {
        Map<String, RuleBuildContext> ruleCxts = this.buildRuleBuilderContexts(rules, pkgRegistry);
        for (RuleDescr ruleDescr : rules) {
            if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName())) continue;
            this.initRuleDescr(packageDescr, pkgRegistry, ruleDescr);
            this.results.addAll(this.addRule(ruleCxts.get(ruleDescr.getName())));
        }
    }

    private Map<String, RuleBuildContext> buildRuleBuilderContexts(List<RuleDescr> rules, PackageRegistry pkgRegistry) {
        HashMap<String, RuleBuildContext> map = new HashMap<String, RuleBuildContext>();
        for (RuleDescr ruleDescr : rules) {
            RuleBuildContext context = this.buildRuleBuilderContext(pkgRegistry, ruleDescr);
            map.put(ruleDescr.getName(), context);
            pkgRegistry.getPackage().addRule(context.getRule());
        }
        return map;
    }

    private RuleBuildContext buildRuleBuilderContext(PackageRegistry pkgRegistry, RuleDescr ruleDescr) {
        if (ruleDescr.getResource() == null) {
            ruleDescr.setResource(this.resource);
        }
        DialectCompiletimeRegistry ctr = pkgRegistry.getDialectCompiletimeRegistry();
        RuleBuildContext context = new RuleBuildContext(this.kBuilder, ruleDescr, ctr, pkgRegistry.getPackage(), ctr.getDialect(pkgRegistry.getDialect()));
        RuleBuilder.preProcess(context);
        return context;
    }

    private void compileRulesLevel(PackageDescr packageDescr, PackageRegistry pkgRegistry, List<RuleDescr> rules) {
        boolean parallelRulesBuild;
        boolean bl = parallelRulesBuild = this.kBase == null && this.parallelRulesBuildThreshold != -1 && rules.size() > this.parallelRulesBuildThreshold;
        if (parallelRulesBuild) {
            ConcurrentHashMap ruleCxts = new ConcurrentHashMap();
            try {
                ((ForkJoinTask)KnowledgeBuilderImpl.ForkJoinPoolHolder.COMPILER_POOL.submit(() -> ((Stream)rules.stream().parallel()).filter(ruleDescr -> this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName())).forEach(ruleDescr -> {
                    this.initRuleDescr(packageDescr, pkgRegistry, (RuleDescr)ruleDescr);
                    RuleBuildContext context = this.buildRuleBuilderContext(pkgRegistry, (RuleDescr)ruleDescr);
                    ruleCxts.put(ruleDescr.getName(), context);
                    List<? extends KnowledgeBuilderResult> results = this.addRule(context);
                    if (!results.isEmpty()) {
                        Collection collection = this.results;
                        synchronized (collection) {
                            this.results.addAll(results);
                        }
                    }
                }))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Rules compilation failed or interrupted", e);
            }
            for (RuleDescr ruleDescr : rules) {
                RuleBuildContext context = (RuleBuildContext)ruleCxts.get(ruleDescr.getName());
                if (context == null) continue;
                pkgRegistry.getPackage().addRule(context.getRule());
            }
        } else {
            for (RuleDescr ruleDescr : rules) {
                if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName())) continue;
                this.initRuleDescr(packageDescr, pkgRegistry, ruleDescr);
                RuleBuildContext context = this.buildRuleBuilderContext(pkgRegistry, ruleDescr);
                this.results.addAll(this.addRule(context));
                pkgRegistry.getPackage().addRule(context.getRule());
            }
        }
    }

    private Collection<RuleImpl> findChildrenRulesToBeRemoved(PackageDescr packageDescr, Collection<RuleImpl> rulesToBeRemoved) {
        HashSet<String> childrenRuleNamesToBeRemoved = new HashSet<String>();
        HashSet<RuleImpl> childrenRulesToBeRemoved = new HashSet<RuleImpl>();
        for (RuleImpl rule : rulesToBeRemoved) {
            if (!rule.hasChildren()) continue;
            for (RuleImpl child : rule.getChildren()) {
                if (rulesToBeRemoved.contains(child)) continue;
                childrenRulesToBeRemoved.add(child);
                childrenRuleNamesToBeRemoved.add(child.getName());
                RuleDescr toBeReadded = new RuleDescr(child.getName());
                toBeReadded.setNamespace(packageDescr.getNamespace());
                packageDescr.addRule(toBeReadded);
            }
        }
        if (!childrenRuleNamesToBeRemoved.isEmpty()) {
            ((CompositePackageDescr)packageDescr).addFilter((type, pkgName, assetName) -> childrenRuleNamesToBeRemoved.contains(assetName) ? KnowledgeBuilderImpl.AssetFilter.Action.UPDATE : KnowledgeBuilderImpl.AssetFilter.Action.DO_NOTHING);
        }
        return childrenRulesToBeRemoved;
    }

    private void initRuleDescr(PackageDescr packageDescr, PackageRegistry pkgRegistry, RuleDescr ruleDescr) {
        if (StringUtils.isEmpty((CharSequence)ruleDescr.getNamespace())) {
            ruleDescr.setNamespace(packageDescr.getNamespace());
        }
        this.inheritPackageAttributes(this.packageAttributes, ruleDescr);
        if (StringUtils.isEmpty((CharSequence)ruleDescr.getDialect())) {
            ruleDescr.addAttribute(new AttributeDescr("dialect", pkgRegistry.getDialect()));
        }
    }

    private void inheritPackageAttributes(Map<String, AttributeDescr> pkgAttributes, RuleDescr ruleDescr) {
        if (pkgAttributes == null) {
            return;
        }
        for (AttributeDescr attrDescr : pkgAttributes.values()) {
            ruleDescr.getAttributes().putIfAbsent(attrDescr.getName(), attrDescr);
        }
    }

    private List<? extends KnowledgeBuilderResult> addRule(RuleBuildContext context) {
        return System.getSecurityManager() == null ? this.internalAddRule(context) : (List)AccessController.doPrivileged(() -> this.internalAddRule(context));
    }

    private List<? extends KnowledgeBuilderResult> internalAddRule(RuleBuildContext context) {
        RuleBuilder.build(context);
        context.getRule().setResource(context.getRuleDescr().getResource());
        context.getDialect().addRule(context);
        if (context.needsStreamMode()) {
            context.getPkg().setNeedStreamMode();
        }
        if (context.getErrors().isEmpty()) {
            return context.getWarnings();
        }
        if (context.getWarnings().isEmpty()) {
            return context.getErrors();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(context.getErrors());
        result.addAll(context.getWarnings());
        return result;
    }

    private static class SortedRules {
        List<RuleDescr> queries;
        final List<List<RuleDescr>> rules = new ArrayList<List<RuleDescr>>();
        List<RuleDescr> current = new ArrayList<RuleDescr>();

        SortedRules() {
            this.newLevel();
        }

        void addRule(RuleDescr rule) {
            this.current.add(rule);
        }

        void newLevel() {
            this.current = new ArrayList<RuleDescr>();
            this.rules.add(this.current);
        }
    }
}

