/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.util.Map;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieMetaInfoBuilder;
import org.kie.api.internal.utils.KieService;
import org.kie.memorycompiler.resources.ResourceStore;

public interface CompilationCacheProvider
extends KieService {
    public static CompilationCacheProvider get() {
        return Holder.INSTANCE;
    }

    public InternalKieModule.CompilationCache getCompilationCache(AbstractKieModule var1, Map<String, InternalKieModule.CompilationCache> var2, String var3);

    public void writeKieModuleMetaInfo(InternalKieModule var1, ResourceStore var2);

    public static class DefaultCompilationCacheProvider
    implements CompilationCacheProvider {
        private static final CompilationCacheProvider INSTANCE = new DefaultCompilationCacheProvider();

        @Override
        public InternalKieModule.CompilationCache getCompilationCache(AbstractKieModule kieModule, Map<String, InternalKieModule.CompilationCache> compilationCache, String kbaseName) {
            return null;
        }

        @Override
        public void writeKieModuleMetaInfo(InternalKieModule kModule, ResourceStore trgMfs) {
            new KieMetaInfoBuilder(kModule).writeKieModuleMetaInfo(trgMfs);
        }
    }

    public static class Holder {
        private static final CompilationCacheProvider INSTANCE = Holder.getCompilationCacheProvider();

        private static CompilationCacheProvider getCompilationCacheProvider() {
            CompilationCacheProvider provider = (CompilationCacheProvider)KieService.load(CompilationCacheProvider.class);
            return provider != null ? provider : DefaultCompilationCacheProvider.INSTANCE;
        }
    }
}

