/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.compiler.builder.DroolsAssemblerContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.DroolsWarning;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.rule.Dialectable;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.parser.DroolsError;

public class PackageBuildContext {
    private InternalKnowledgePackage pkg;
    private TypeDeclarationContext kBuilder;
    private BaseDescr parentDescr;
    private final List<DroolsError> errors = Collections.synchronizedList(new ArrayList());
    private final List<DroolsWarning> warnings = Collections.synchronizedList(new ArrayList());
    private final List<String> methods = Collections.synchronizedList(new ArrayList());
    private final Map<String, String> invokers = new ConcurrentHashMap<String, String>();
    private final Map<String, Object> invokerLookups = new ConcurrentHashMap<String, Object>();
    private final Map<String, BaseDescr> descrLookups = new ConcurrentHashMap<String, BaseDescr>();
    private int counter;
    private DialectCompiletimeRegistry dialectRegistry;
    private Dialect dialect;
    private boolean typesafe;

    public void initContext(TypeDeclarationContext kBuilder, InternalKnowledgePackage pkg, BaseDescr parentDescr, DialectCompiletimeRegistry dialectRegistry, Dialect defaultDialect, Dialectable component) {
        this.kBuilder = kBuilder;
        this.pkg = pkg;
        this.parentDescr = parentDescr;
        this.dialectRegistry = dialectRegistry;
        this.dialect = component != null && component.getDialect() != null ? this.dialectRegistry.getDialect(component.getDialect()) : defaultDialect;
        this.typesafe = this.isStrictMode(dialectRegistry);
        if (this.dialect == null && component != null && component.getDialect() != null) {
            this.errors.add(new DescrBuildError(null, parentDescr, component, "Unable to load Dialect '" + component.getDialect() + "'"));
            this.dialect = defaultDialect;
        }
    }

    @Deprecated
    public void init(DroolsAssemblerContext kBuilder, InternalKnowledgePackage pkg, BaseDescr parentDescr, DialectCompiletimeRegistry dialectRegistry, Dialect defaultDialect, Dialectable component) {
        this.initContext((TypeDeclarationContext)((Object)kBuilder), pkg, parentDescr, dialectRegistry, defaultDialect, component);
    }

    private boolean isStrictMode(DialectCompiletimeRegistry dialectRegistry) {
        return dialectRegistry.getDialect("mvel") == null || dialectRegistry.getDialect("mvel").isStrictMode();
    }

    public BaseDescr getParentDescr() {
        return this.parentDescr;
    }

    public void setParentDescr(BaseDescr descr) {
        this.parentDescr = descr;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public Dialect getDialect(String dialectName) {
        return this.dialectRegistry.getDialect(dialectName);
    }

    public DialectCompiletimeRegistry getDialectRegistry() {
        return this.dialectRegistry;
    }

    public List<DroolsError> getErrors() {
        return this.errors;
    }

    public void addError(DroolsError error) {
        this.errors.add(error);
    }

    public List<DroolsWarning> getWarnings() {
        return this.warnings;
    }

    public void addWarning(DroolsWarning warning) {
        this.warnings.add(warning);
    }

    public InternalKnowledgePackage getPkg() {
        return this.pkg;
    }

    public BaseDescr getDescrLookup(String className) {
        return this.descrLookups.get(className);
    }

    public void addDescrLookups(String className, BaseDescr baseDescr) {
        this.descrLookups.put(className, baseDescr);
    }

    public Object getInvokerLookup(String className) {
        return this.invokerLookups.get(className);
    }

    public void addInvokerLookup(String className, Object invokerLookup) {
        this.invokerLookups.put(className, invokerLookup);
    }

    public Map<String, String> getInvokers() {
        return this.invokers;
    }

    public void addInvoker(String invokerClassName, String invoker) {
        this.invokers.put(invokerClassName, invoker);
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void addMethod(String method) {
        this.methods.add(method);
    }

    public int getCurrentId() {
        return this.counter;
    }

    public int getNextId() {
        return this.counter++;
    }

    public KnowledgeBuilderConfigurationImpl getConfiguration() {
        return this.kBuilder.getBuilderConfiguration();
    }

    public TypeDeclarationContext getKnowledgeBuilder() {
        return this.kBuilder;
    }

    public boolean isTypesafe() {
        return this.typesafe;
    }

    public void setTypesafe(boolean stricttype) {
        this.typesafe = stricttype;
    }

    public Class<?> resolveVarType(String identifier) {
        return this.getKnowledgeBuilder().getGlobals().get(identifier);
    }
}

