/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import org.drools.compiler.builder.InternalKnowledgeBuilder;
import org.drools.compiler.builder.conf.DecisionTableConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.kie.builder.impl.BuildContext;
import org.drools.compiler.kie.builder.impl.CompilationCacheProvider;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.KnowledgePackagesBuildResult;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.io.InternalResource;
import org.drools.io.ResourceConfigurationImpl;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.util.StringUtils;
import org.drools.wiring.api.ResourceProvider;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.RuleTemplateModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.ResourceChangeSet;
import org.kie.internal.builder.RuleTemplateConfiguration;
import org.kie.internal.io.ResourceTypeImpl;
import org.kie.util.maven.support.DependencyFilter;
import org.kie.util.maven.support.PomModel;
import org.kie.util.maven.support.ReleaseIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieModule
implements InternalKieModule,
Serializable {
    private static final String SPRING_BOOT_PREFIX = "BOOT-INF/classes/";
    private static final Logger log = LoggerFactory.getLogger(AbstractKieModule.class);
    private final transient Map<String, KnowledgeBuilder> kBuilders = new HashMap<String, KnowledgeBuilder>();
    private final transient Map<String, Results> resultsCache = new HashMap<String, Results>();
    protected ReleaseId releaseId;
    private transient KieModuleModel kModuleModel;
    private Map<ReleaseId, InternalKieModule> kieDependencies;
    protected Map<String, InternalKieModule.CompilationCache> compilationCache = new HashMap<String, InternalKieModule.CompilationCache>();
    private final transient Map<String, ResourceConfiguration> resourceConfigurationCache = new HashMap<String, ResourceConfiguration>();
    protected transient PomModel pomModel;
    private Collection<ReleaseId> unresolvedDependencies;

    public AbstractKieModule() {
    }

    public AbstractKieModule(ReleaseId releaseId, KieModuleModel kModuleModel) {
        this.releaseId = releaseId;
        this.kModuleModel = kModuleModel;
    }

    @Override
    public KieModuleModel getKieModuleModel() {
        return this.kModuleModel;
    }

    @Override
    public Map<ReleaseId, InternalKieModule> getKieDependencies() {
        return this.kieDependencies == null ? Collections.emptyMap() : this.kieDependencies;
    }

    @Override
    public void addKieDependency(InternalKieModule dependency) {
        if (this.kieDependencies == null) {
            this.kieDependencies = new HashMap<ReleaseId, InternalKieModule>();
        }
        this.kieDependencies.put(dependency.getReleaseId(), dependency);
    }

    @Override
    public Collection<ReleaseId> getJarDependencies(DependencyFilter filter) {
        if (this.pomModel == null) {
            this.getPomModel();
        }
        Collection deps = null;
        if (this.pomModel != null) {
            deps = this.pomModel.getDependencies(filter);
        }
        return deps == null ? Collections.emptyList() : deps;
    }

    @Override
    public Collection<ReleaseId> getUnresolvedDependencies() {
        return this.unresolvedDependencies == null ? Collections.emptyList() : this.unresolvedDependencies;
    }

    @Override
    public void setUnresolvedDependencies(Collection<ReleaseId> unresolvedDependencies) {
        this.unresolvedDependencies = unresolvedDependencies;
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        return this.kBuilders.isEmpty() ? null : ((InternalKnowledgeBuilder)this.kBuilders.values().iterator().next()).getRootClassLoader();
    }

    @Override
    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
        return this.kBuilders.get(kieBaseName);
    }

    @Override
    public InternalKnowledgePackage getPackage(String packageName) {
        for (KnowledgeBuilder kbuilder : this.kBuilders.values()) {
            InternalKnowledgePackage pkg = ((InternalKnowledgeBuilder)kbuilder).getPackage(packageName);
            if (pkg == null) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public Collection<KiePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
        KnowledgeBuilder kbuilder = this.kBuilders.get(kieBaseName);
        return kbuilder != null ? kbuilder.getKnowledgePackages() : null;
    }

    @Override
    public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
        this.kBuilders.put(kieBaseName, kbuilder);
    }

    @Override
    public Map<String, Results> getKnowledgeResultsCache() {
        return this.resultsCache;
    }

    @Override
    public void cacheResultsForKieBase(String kieBaseName, Results results) {
        this.resultsCache.put(kieBaseName, results);
    }

    @Override
    public Map<String, byte[]> getClassesMap() {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (String fileName : this.getFileNames()) {
            if (!fileName.endsWith(".class")) continue;
            classes.put(fileName, this.getBytes(fileName));
        }
        return classes;
    }

    public KnowledgePackagesBuildResult buildKnowledgePackages(KieBaseModelImpl kBaseModel, KieProject kieProject, BuildContext buildContext) {
        Collection pkgs = this.getKnowledgePackagesForKieBase(kBaseModel.getName());
        if (pkgs == null) {
            KnowledgeBuilder kbuilder = kieProject.buildKnowledgePackages(kBaseModel, buildContext);
            if (kbuilder.hasErrors()) {
                return new KnowledgePackagesBuildResult(true, pkgs);
            }
            pkgs = kbuilder.getKnowledgePackages();
        }
        return new KnowledgePackagesBuildResult(false, pkgs);
    }

    @Override
    public InternalKnowledgeBase createKieBase(KieBaseModelImpl kBaseModel, KieProject kieProject, BuildContext buildContext, KieBaseConfiguration conf) {
        KnowledgePackagesBuildResult knowledgePackagesBuildResult = this.buildKnowledgePackages(kBaseModel, kieProject, buildContext);
        if (knowledgePackagesBuildResult.hasErrors()) {
            return null;
        }
        Collection<KiePackage> pkgs = knowledgePackagesBuildResult.getPkgs();
        AbstractKieModule.checkStreamMode(kBaseModel, conf, pkgs);
        ClassLoader cl = kieProject.getClassLoader();
        if (conf == null) {
            conf = this.getKnowledgeBaseConfiguration(kBaseModel, cl);
        } else if (conf instanceof RuleBaseConfiguration) {
            ((RuleBaseConfiguration)conf).setClassLoader(cl);
        }
        RuleBase kBase = RuleBaseFactory.newRuleBase((String)kBaseModel.getName(), (KieBaseConfiguration)conf);
        kBase.addPackages(pkgs);
        return KnowledgeBaseFactory.newKnowledgeBase((RuleBase)kBase);
    }

    public static void checkStreamMode(KieBaseModel kBaseModel, KieBaseConfiguration conf, Collection<? extends KiePackage> pkgs) {
        if (kBaseModel.getEventProcessingMode() == EventProcessingOption.CLOUD && (conf == null || conf.getOption(EventProcessingOption.class) == EventProcessingOption.CLOUD)) {
            for (KiePackage kiePackage : pkgs) {
                if (!((KnowledgePackageImpl)kiePackage).needsStreamMode()) continue;
                throw new RuntimeException("The requested KieBase \"" + kBaseModel.getName() + "\" has been set to run in CLOUD mode but requires features only available in STREAM mode");
            }
        }
    }

    private KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModelImpl kBaseModel, ClassLoader cl) {
        KieBaseConfiguration kbConf = RuleBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{cl});
        kbConf.setOption((KieBaseOption)kBaseModel.getEqualsBehavior());
        kbConf.setOption((KieBaseOption)kBaseModel.getEventProcessingMode());
        kbConf.setOption((KieBaseOption)kBaseModel.getDeclarativeAgenda());
        kbConf.setOption((KieBaseOption)kBaseModel.getSequential());
        kbConf.setOption((KieBaseOption)kBaseModel.getSessionsPool());
        return kbConf;
    }

    @Override
    public KnowledgeBuilderConfiguration createBuilderConfiguration(KieBaseModel kBaseModel, ClassLoader classLoader) {
        KnowledgeBuilderConfigurationImpl pconf = (KnowledgeBuilderConfigurationImpl)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((ClassLoader)classLoader);
        pconf.setCompilationCache(this.getCompilationCache(kBaseModel.getName()));
        AbstractKieModule.setModelPropsOnConf(((KieBaseModelImpl)kBaseModel).getKModule(), pconf);
        return pconf;
    }

    static void setModelPropsOnConf(KieModuleModel kModuleModel, KnowledgeBuilderConfigurationImpl pconf) {
        for (Map.Entry entry : kModuleModel.getConfigurationProperties().entrySet()) {
            pconf.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public final boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName) {
        return this.addResourceToCompiler(ckbuilder, kieBaseModel, fileName, null);
    }

    @Override
    public final boolean addResourceToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName, ResourceChangeSet rcs) {
        InternalResource resource = this.getResource(fileName);
        if (resource != null) {
            ResourceType resourceType;
            ResourceConfiguration conf = this.getResourceConfiguration(fileName);
            ResourceType resourceType2 = resourceType = conf instanceof ResourceConfigurationImpl && ((ResourceConfigurationImpl)conf).getResourceType() != null ? ((ResourceConfigurationImpl)conf).getResourceType() : ResourceType.determineResourceType((String)fileName);
            if (resourceType == ResourceType.DTABLE && conf instanceof DecisionTableConfiguration) {
                this.addDTableToCompiler(ckbuilder, kieBaseModel, fileName, (Resource)resource, rcs, (DecisionTableConfiguration)conf);
            } else {
                ckbuilder.add((Resource)resource, resourceType, conf, rcs);
            }
            return true;
        }
        return false;
    }

    private void addDTableToCompiler(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, String fileName, Resource resource, ResourceChangeSet rcs, DecisionTableConfiguration dtableConf) {
        for (RuleTemplateModel template : kieBaseModel.getRuleTemplates()) {
            boolean isInSpringBoot = fileName.startsWith(SPRING_BOOT_PREFIX);
            if (isInSpringBoot) {
                fileName = fileName.substring(SPRING_BOOT_PREFIX.length());
            }
            if (!template.getDtable().equals(fileName)) continue;
            InternalResource templateResource = this.getResource((isInSpringBoot ? SPRING_BOOT_PREFIX : "") + template.getTemplate());
            if (templateResource != null) {
                dtableConf.addRuleTemplateConfiguration((Resource)templateResource, template.getRow(), template.getCol());
                continue;
            }
            throw new RuntimeException("Cannot find resource: '" + template.getTemplate() + "'");
        }
        AbstractKieModule.addDTableToCompiler(ckbuilder, resource, dtableConf, rcs);
    }

    public static void addDTableToCompiler(CompositeKnowledgeBuilder ckbuilder, Resource resource, DecisionTableConfiguration dtableConf) {
        AbstractKieModule.addDTableToCompiler(ckbuilder, resource, dtableConf, null);
    }

    private static void addDTableToCompiler(CompositeKnowledgeBuilder ckbuilder, Resource resource, DecisionTableConfiguration dtableConf, ResourceChangeSet rcs) {
        String sheetNames = dtableConf.getWorksheetName();
        if (sheetNames == null || sheetNames.indexOf(44) < 0) {
            ckbuilder.add(resource, ResourceType.DTABLE, (ResourceConfiguration)dtableConf, rcs);
        } else {
            for (String sheetName : sheetNames.split("\\,")) {
                ckbuilder.add(resource, ResourceType.DTABLE, (ResourceConfiguration)new DecisionTableConfigurationDelegate(dtableConf, sheetName), rcs);
            }
        }
    }

    @Override
    public boolean hasResource(String fileName) {
        byte[] bytes = this.getBytes(fileName);
        return bytes != null && bytes.length > 0;
    }

    @Override
    public ResourceConfiguration getResourceConfiguration(String fileName) {
        return this.resourceConfigurationCache.computeIfAbsent(fileName, this::loadResourceConfiguration);
    }

    private ResourceConfiguration loadResourceConfiguration(String fileName) {
        return AbstractKieModule.loadResourceConfiguration(fileName, this::isAvailable, file -> new ByteArrayInputStream(this.getBytes(fileName + ".properties")));
    }

    public static ResourceConfiguration loadResourceConfiguration(String fileName, Predicate<String> fileAvailable, Function<String, InputStream> fileProvider) {
        ResourceConfiguration conf;
        int lastDot;
        Properties prop = new Properties();
        if (fileAvailable.test(fileName + ".properties")) {
            try (InputStream input = fileProvider.apply(fileName + ".properties");){
                prop.load(input);
            }
            catch (IOException e) {
                log.error(String.format("Error loading resource configuration from file: %s.properties", fileName));
            }
        }
        if (ResourceType.DTABLE.matchesExtension(fileName) && (lastDot = fileName.lastIndexOf(46)) >= 0 && fileName.length() > lastDot + 1) {
            String extension = fileName.substring(lastDot + 1);
            Object confClass = prop.get("kie.resource.conf.class");
            if (confClass == null || confClass.toString().equals(ResourceConfigurationImpl.class.getCanonicalName())) {
                prop.setProperty("kie.resource.conf.class", DecisionTableConfigurationImpl.class.getName());
            }
            prop.setProperty("drools.dt.type", DecisionTableInputType.valueOf((String)extension.toUpperCase()).toString());
        }
        ResourceConfiguration resourceConfiguration = conf = prop.isEmpty() ? null : ResourceTypeImpl.fromProperties((Properties)prop);
        if (conf instanceof DecisionTableConfiguration && ((DecisionTableConfiguration)conf).getWorksheetName() == null) {
            ((DecisionTableConfiguration)conf).setWorksheetName(prop.getProperty("sheets"));
        }
        return conf;
    }

    @Override
    public InternalKieModule.CompilationCache getCompilationCache(String kbaseName) {
        return CompilationCacheProvider.get().getCompilationCache(this, this.compilationCache, kbaseName);
    }

    @Override
    public PomModel getPomModel() {
        if (this.pomModel == null) {
            try {
                byte[] pomXml = this.getPomXml();
                if (pomXml != null) {
                    PomModel tempPomModel = PomModel.Parser.parse((String)"pom.xml", (InputStream)new ByteArrayInputStream(pomXml));
                    this.validatePomModel(tempPomModel);
                    this.pomModel = tempPomModel;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.pomModel;
    }

    public void setPomModel(PomModel pomModel) {
        this.pomModel = pomModel;
    }

    private void validatePomModel(PomModel pomModel) {
        ReleaseId pomReleaseId = pomModel.getReleaseId();
        if (StringUtils.isEmpty((CharSequence)pomReleaseId.getGroupId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getArtifactId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getVersion())) {
            throw new RuntimeException("Maven pom.properties exists but ReleaseId content is malformed");
        }
    }

    private byte[] getPomXml() {
        return this.getBytes(((ReleaseIdImpl)this.releaseId).getPomXmlPath());
    }

    @Override
    public InputStream getPomAsStream() {
        byte[] pom = this.getBytes(((ReleaseIdImpl)this.releaseId).getPomXmlPath());
        return pom != null ? new ByteArrayInputStream(pom) : null;
    }

    public static boolean updateResource(CompositeKnowledgeBuilder ckbuilder, InternalKieModule kieModule, String resourceName, ResourceChangeSet changes) {
        ResourceConfiguration conf = kieModule.getResourceConfiguration(resourceName);
        InternalResource resource = kieModule.getResource(resourceName);
        if (resource != null) {
            if (conf == null) {
                ckbuilder.add((Resource)resource, ResourceType.determineResourceType((String)resourceName), changes);
            } else {
                ckbuilder.add((Resource)resource, ResourceType.determineResourceType((String)resourceName), conf, changes);
            }
            return true;
        }
        return false;
    }

    @Override
    public ResourceProvider createResourceProvider() {
        try {
            return new KieModuleResourceProvider(this, this.getFile().toURI().toURL());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class KieModuleResourceProvider
    implements ResourceProvider {
        private final InternalKieModule kieModule;
        private final URL kieModuleUrl;

        private KieModuleResourceProvider(InternalKieModule kieModule, URL kieModuleUrl) {
            this.kieModule = kieModule;
            this.kieModuleUrl = kieModuleUrl;
        }

        public InputStream getResourceAsStream(String name) throws IOException {
            InternalResource resource;
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return (resource = this.kieModule.getResource(name)) != null ? resource.getInputStream() : null;
        }

        public URL getResource(String name) {
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return this.kieModule.hasResource(name) ? this.createURLForResource(name) : null;
        }

        private URL createURLForResource(String name) {
            try {
                if (this.kieModule instanceof ZipKieModule) {
                    return new URL("jar", "", this.kieModuleUrl + "!/" + name);
                }
                return new URL(this.kieModuleUrl, name);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }

    static class DecisionTableConfigurationDelegate
    implements DecisionTableConfiguration {
        private final DecisionTableConfiguration delegate;
        private final String sheetName;

        DecisionTableConfigurationDelegate(DecisionTableConfiguration delegate, String sheetName) {
            this.delegate = delegate;
            this.sheetName = sheetName;
        }

        public void setInputType(DecisionTableInputType inputType) {
            this.delegate.setInputType(inputType);
        }

        public DecisionTableInputType getInputType() {
            return this.delegate.getInputType();
        }

        public void setWorksheetName(String name) {
            throw new UnsupportedOperationException();
        }

        public String getWorksheetName() {
            return this.sheetName;
        }

        public void addRuleTemplateConfiguration(Resource template, int row, int col) {
            this.delegate.addRuleTemplateConfiguration(template, row, col);
        }

        public List<RuleTemplateConfiguration> getRuleTemplateConfigurations() {
            return this.delegate.getRuleTemplateConfigurations();
        }

        public boolean isTrimCell() {
            return this.delegate.isTrimCell();
        }

        public void setTrimCell(boolean trimCell) {
            this.delegate.setTrimCell(trimCell);
        }

        public Properties toProperties() {
            return this.delegate.toProperties();
        }

        public ResourceConfiguration fromProperties(Properties prop) {
            return this.delegate.fromProperties(prop);
        }
    }
}

