/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.builder.impl.EvaluatorRegistry;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.compiler.rule.builder.util.AccumulateUtil;
import org.drools.core.BaseConfiguration;
import org.drools.drl.parser.DrlParser;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.OptionKey;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.conf.AccumulateFunctionOption;
import org.kie.internal.builder.conf.AlphaNetworkCompilerOption;
import org.kie.internal.builder.conf.EvaluatorOption;
import org.kie.internal.builder.conf.ExternaliseCanonicalModelLambdaOption;
import org.kie.internal.builder.conf.GroupDRLsInKieBasesByFolderOption;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.builder.conf.MultiValueKieBuilderOption;
import org.kie.internal.builder.conf.ParallelLambdaExternalizationOption;
import org.kie.internal.builder.conf.ParallelRulesBuildThresholdOption;
import org.kie.internal.builder.conf.ProcessStringEscapesOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.builder.conf.SingleValueKieBuilderOption;
import org.kie.internal.builder.conf.TrimCellsInDTableOption;
import org.kie.internal.conf.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBuilderRulesConfigurationImpl
extends BaseConfiguration<KnowledgeBuilderOption, SingleValueKieBuilderOption, MultiValueKieBuilderOption>
implements KnowledgeBuilderConfiguration {
    private static final int DEFAULT_PARALLEL_RULES_BUILD_THRESHOLD = 10;
    public static final ConfigurationKey<KnowledgeBuilderRulesConfigurationImpl> KEY = new ConfigurationKey("Rule");
    private ParallelRulesBuildThresholdOption parallelRulesBuildThreshold = ParallelRulesBuildThresholdOption.get((int)10);
    private Map<String, AccumulateFunction> accumulateFunctions;
    private EvaluatorRegistry evaluatorRegistry;
    private boolean processStringEscapes = true;
    private boolean trimCellsInDTable = true;
    private boolean groupDRLsInKieBasesByFolder = false;
    private boolean externaliseCanonicalModelLambda = true;
    private boolean parallelLambdaExternalization = true;
    private AlphaNetworkCompilerOption alphaNetworkCompilerOption = AlphaNetworkCompilerOption.DISABLED;
    private static final PropertySpecificOption DEFAULT_PROP_SPEC_OPT = PropertySpecificOption.ALWAYS;
    private PropertySpecificOption propertySpecificOption = DEFAULT_PROP_SPEC_OPT;
    private LanguageLevelOption languageLevel = DrlParser.DEFAULT_LANGUAGE_LEVEL;
    private InternalKieModule.CompilationCache compilationCache = null;
    private static final Logger log = LoggerFactory.getLogger(KnowledgeBuilderRulesConfigurationImpl.class);

    public KnowledgeBuilderRulesConfigurationImpl(CompositeConfiguration<KnowledgeBuilderOption, SingleValueKieBuilderOption, MultiValueKieBuilderOption> compConfig) {
        super(compConfig);
        this.init();
    }

    private void init() {
        this.setProperty("drools.trimCellsInDTable", this.getPropertyValue("drools.trimCellsInDTable", "true"));
        this.setProperty("drools.groupDRLsInKieBasesByFolder", this.getPropertyValue("drools.groupDRLsInKieBasesByFolder", "false"));
        this.setProperty("drools.propertySpecific", this.getPropertyValue("drools.propertySpecific", DEFAULT_PROP_SPEC_OPT.toString()));
        this.setProperty("drools.lang.level", this.getPropertyValue("drools.lang.level", DrlParser.DEFAULT_LANGUAGE_LEVEL.toString()));
        this.setProperty("drools.parallelRulesBuildThreshold", this.getPropertyValue("drools.parallelRulesBuildThreshold", String.valueOf(10)));
        this.accumulateFunctions = AccumulateUtil.buildAccumulateFunctionsMap(this.getProperties(), this.getFunctionFactoryClassLoader());
        this.buildEvaluatorRegistry();
        this.setProperty("drools.parser.processStringEscapes", this.getPropertyValue("drools.parser.processStringEscapes", "true"));
        this.setProperty("drools.alphaNetworkCompiler", this.getPropertyValue("drools.alphaNetworkCompiler", "disabled"));
        this.setProperty("drools.externaliseCanonicalModelLambda", this.getPropertyValue("drools.externaliseCanonicalModelLambda", "true"));
        this.setProperty("drools.parallelLambdaExternalization", this.getPropertyValue("drools.parallelLambdaExternalization", "true"));
    }

    protected ClassLoader getFunctionFactoryClassLoader() {
        return this.getClassLoader();
    }

    public boolean setInternalProperty(String name, String value) {
        switch (name) {
            case "drools.parser.processStringEscapes": {
                this.setProcessStringEscapes(Boolean.parseBoolean(value));
                break;
            }
            case "drools.trimCellsInDTable": {
                this.setTrimCellsInDTable(Boolean.parseBoolean(value));
                break;
            }
            case "drools.groupDRLsInKieBasesByFolder": {
                this.setGroupDRLsInKieBasesByFolder(Boolean.parseBoolean(value));
                break;
            }
            case "drools.propertySpecific": {
                try {
                    this.setPropertySpecificOption(PropertySpecificOption.valueOf((String)value.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Invalid value " + value + " for option drools.propertySpecific");
                }
                break;
            }
            case "drools.lang.level": {
                try {
                    this.setLanguageLevel(LanguageLevelOption.valueOf((String)value.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Invalid value " + value + " for option drools.lang.level");
                }
                break;
            }
            case "drools.parallelRulesBuildThreshold": {
                this.setParallelRulesBuildThreshold(Integer.parseInt(value));
                break;
            }
            case "drools.externaliseCanonicalModelLambda": {
                this.setExternaliseCanonicalModelLambda(Boolean.parseBoolean(value));
                break;
            }
            case "drools.parallelLambdaExternalization": {
                this.setParallelLambdaExternalization(Boolean.parseBoolean(value));
                break;
            }
            case "drools.alphaNetworkCompiler": {
                try {
                    this.setAlphaNetworkCompilerOption(AlphaNetworkCompilerOption.determineAlphaNetworkCompilerMode((String)value.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    log.warn("Invalid value " + value + " for option drools.alphaNetworkCompiler");
                }
                break;
            }
            default: {
                if (name.startsWith("drools.accumulate.function.")) {
                    this.addAccumulateFunction(name.substring("drools.accumulate.function.".length()), value);
                    break;
                }
                if (name.startsWith("drools.evaluator.")) {
                    this.evaluatorRegistry.addEvaluatorDefinition(value);
                    break;
                }
                return false;
            }
        }
        return true;
    }

    public String getInternalProperty(String name) {
        switch (name) {
            case "drools.parser.processStringEscapes": {
                return String.valueOf(this.isProcessStringEscapes());
            }
            case "drools.trimCellsInDTable": {
                return String.valueOf(this.isTrimCellsInDTable());
            }
            case "drools.groupDRLsInKieBasesByFolder": {
                return String.valueOf(this.isGroupDRLsInKieBasesByFolder());
            }
            case "drools.lang.level": {
                return "" + this.getLanguageLevel();
            }
            case "drools.parallelRulesBuildThreshold": {
                return String.valueOf(this.getParallelRulesBuildThreshold());
            }
            case "drools.externaliseCanonicalModelLambda": {
                return String.valueOf(this.isExternaliseCanonicalModelLambda());
            }
            case "drools.parallelLambdaExternalization": {
                return String.valueOf(this.isParallelLambdaExternalization());
            }
        }
        if (name.startsWith("drools.accumulate.function.")) {
            int index = "drools.accumulate.function.".length();
            AccumulateFunction function = this.accumulateFunctions.get(name.substring(index));
            return function != null ? function.getClass().getName() : null;
        }
        if (name.startsWith("drools.evaluator.")) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            EvaluatorDefinition evalDef = this.evaluatorRegistry.getEvaluatorDefinition(key);
            return evalDef != null ? evalDef.getClass().getName() : null;
        }
        return null;
    }

    public void addAccumulateFunction(String identifier, String className) {
        this.accumulateFunctions.put(identifier, AccumulateUtil.loadAccumulateFunction(this.getClassLoader(), identifier, className));
    }

    public void addAccumulateFunction(String identifier, Class<? extends AccumulateFunction> clazz) {
        try {
            this.accumulateFunctions.put(identifier, clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Instantiation failed for class " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error loading accumulate function for identifier " + identifier + ". Illegal access to class " + clazz.getName(), e);
        }
    }

    public AccumulateFunction getAccumulateFunction(String identifier) {
        return this.accumulateFunctions.get(identifier);
    }

    public Collection<String> getAccumulateFunctionNames() {
        return this.accumulateFunctions.keySet();
    }

    private void buildEvaluatorRegistry() {
        this.evaluatorRegistry = new EvaluatorRegistry(this.getFunctionFactoryClassLoader());
        HashMap temp = new HashMap();
        this.getProperties().mapStartsWith(temp, "drools.evaluator.", true);
        for (Map.Entry e : temp.entrySet()) {
            String key = (String)e.getKey();
            if ("drools.evaluator.equality".equals(key) || "drools.evaluator.comparable".equals(key)) continue;
            this.evaluatorRegistry.addEvaluatorDefinition((String)e.getValue());
        }
    }

    public EvaluatorRegistry getEvaluatorRegistry() {
        return this.evaluatorRegistry;
    }

    public void addEvaluatorDefinition(String className) {
        this.evaluatorRegistry.addEvaluatorDefinition(className);
    }

    public void addEvaluatorDefinition(EvaluatorDefinition def) {
        this.evaluatorRegistry.addEvaluatorDefinition(def);
    }

    public boolean isProcessStringEscapes() {
        return this.processStringEscapes;
    }

    public void setProcessStringEscapes(boolean processStringEscapes) {
        this.processStringEscapes = processStringEscapes;
    }

    public boolean isTrimCellsInDTable() {
        return this.trimCellsInDTable;
    }

    public void setTrimCellsInDTable(boolean trimCellsInDTable) {
        this.trimCellsInDTable = trimCellsInDTable;
    }

    public boolean isGroupDRLsInKieBasesByFolder() {
        return this.groupDRLsInKieBasesByFolder;
    }

    public void setGroupDRLsInKieBasesByFolder(boolean groupDRLsInKieBasesByFolder) {
        this.groupDRLsInKieBasesByFolder = groupDRLsInKieBasesByFolder;
    }

    public int getParallelRulesBuildThreshold() {
        return this.parallelRulesBuildThreshold.getParallelRulesBuildThreshold();
    }

    public void setParallelRulesBuildThreshold(int parallelRulesBuildThreshold) {
        this.parallelRulesBuildThreshold = ParallelRulesBuildThresholdOption.get((int)parallelRulesBuildThreshold);
    }

    public LanguageLevelOption getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(LanguageLevelOption languageLevel) {
        this.languageLevel = languageLevel;
    }

    public PropertySpecificOption getPropertySpecificOption() {
        return this.propertySpecificOption;
    }

    public void setPropertySpecificOption(PropertySpecificOption propertySpecificOption) {
        this.propertySpecificOption = propertySpecificOption;
    }

    public boolean isExternaliseCanonicalModelLambda() {
        return this.externaliseCanonicalModelLambda;
    }

    public void setExternaliseCanonicalModelLambda(boolean externaliseCanonicalModelLambda) {
        this.externaliseCanonicalModelLambda = externaliseCanonicalModelLambda;
    }

    public boolean isParallelLambdaExternalization() {
        return this.parallelLambdaExternalization;
    }

    public void setParallelLambdaExternalization(boolean parallelLambdaExternalization) {
        this.parallelLambdaExternalization = parallelLambdaExternalization;
    }

    public AlphaNetworkCompilerOption getAlphaNetworkCompilerOption() {
        return this.alphaNetworkCompilerOption;
    }

    public void setAlphaNetworkCompilerOption(AlphaNetworkCompilerOption alphaNetworkCompilerOption) {
        this.alphaNetworkCompilerOption = alphaNetworkCompilerOption;
    }

    public <T extends SingleValueKieBuilderOption> T getOption(OptionKey<T> option) {
        switch (option.name()) {
            case "drools.parser.processStringEscapes": {
                return (T)(this.processStringEscapes ? ProcessStringEscapesOption.YES : ProcessStringEscapesOption.NO);
            }
            case "drools.trimCellsInDTable": {
                return (T)(this.trimCellsInDTable ? TrimCellsInDTableOption.ENABLED : TrimCellsInDTableOption.DISABLED);
            }
            case "drools.groupDRLsInKieBasesByFolder": {
                return (T)(this.groupDRLsInKieBasesByFolder ? GroupDRLsInKieBasesByFolderOption.ENABLED : GroupDRLsInKieBasesByFolderOption.DISABLED);
            }
            case "drools.propertySpecific": {
                return (T)this.propertySpecificOption;
            }
            case "drools.lang.level": {
                return (T)this.languageLevel;
            }
            case "drools.externaliseCanonicalModelLambda": {
                return (T)(this.externaliseCanonicalModelLambda ? ExternaliseCanonicalModelLambdaOption.ENABLED : ExternaliseCanonicalModelLambdaOption.DISABLED);
            }
            case "drools.parallelLambdaExternalization": {
                return (T)(this.parallelLambdaExternalization ? ParallelLambdaExternalizationOption.ENABLED : ParallelLambdaExternalizationOption.DISABLED);
            }
            case "drools.parallelRulesBuildThreshold": {
                return (T)this.parallelRulesBuildThreshold;
            }
            case "drools.alphaNetworkCompiler": {
                return (T)this.alphaNetworkCompilerOption;
            }
        }
        return (T)((SingleValueKieBuilderOption)this.compConfig.getOption(option));
    }

    public <T extends MultiValueKieBuilderOption> T getOption(OptionKey<T> option, String subKey) {
        switch (option.name()) {
            case "drools.accumulate.function.": {
                return (T)AccumulateFunctionOption.get((String)subKey, (AccumulateFunction)this.accumulateFunctions.get(subKey));
            }
            case "drools.evaluator.": {
                return (T)EvaluatorOption.get((String)subKey, (org.kie.api.runtime.rule.EvaluatorDefinition)this.evaluatorRegistry.getEvaluatorDefinition(subKey));
            }
        }
        return (T)((MultiValueKieBuilderOption)this.compConfig.getOption(option, subKey));
    }

    public <T extends MultiValueKieBuilderOption> Set<String> getOptionSubKeys(OptionKey<T> option) {
        switch (option.name()) {
            case "drools.accumulate.function.": {
                return this.accumulateFunctions.keySet();
            }
            case "drools.evaluator.": {
                return this.evaluatorRegistry.keySet();
            }
        }
        return this.compConfig.getOptionSubKeys(option);
    }

    public <T extends KnowledgeBuilderOption> void setOption(T option) {
        switch (option.propertyName()) {
            case "drools.accumulate.function.": {
                this.accumulateFunctions.put(((AccumulateFunctionOption)option).getName(), ((AccumulateFunctionOption)option).getFunction());
                break;
            }
            case "drools.evaluator.": {
                this.evaluatorRegistry.addEvaluatorDefinition((EvaluatorDefinition)((EvaluatorOption)option).getEvaluatorDefinition());
                break;
            }
            case "drools.parser.processStringEscapes": {
                this.processStringEscapes = ((ProcessStringEscapesOption)option).isProcessStringEscapes();
                break;
            }
            case "drools.trimCellsInDTable": {
                this.setTrimCellsInDTable(((TrimCellsInDTableOption)option).isTrimCellsInDTable());
                break;
            }
            case "drools.groupDRLsInKieBasesByFolder": {
                this.setGroupDRLsInKieBasesByFolder(((GroupDRLsInKieBasesByFolderOption)option).isGroupDRLsInKieBasesByFolder());
                break;
            }
            case "drools.propertySpecific": {
                this.propertySpecificOption = (PropertySpecificOption)option;
                break;
            }
            case "drools.lang.level": {
                this.languageLevel = (LanguageLevelOption)option;
                break;
            }
            case "drools.externaliseCanonicalModelLambda": {
                this.externaliseCanonicalModelLambda = ((ExternaliseCanonicalModelLambdaOption)option).isCanonicalModelLambdaExternalized();
                break;
            }
            case "drools.parallelLambdaExternalization": {
                this.parallelLambdaExternalization = ((ParallelLambdaExternalizationOption)option).isLambdaExternalizationParallel();
                break;
            }
            case "drools.parallelRulesBuildThreshold": {
                this.parallelRulesBuildThreshold = (ParallelRulesBuildThresholdOption)option;
                break;
            }
            case "drools.alphaNetworkCompiler": {
                this.alphaNetworkCompilerOption = (AlphaNetworkCompilerOption)option;
                break;
            }
            default: {
                this.compConfig.setOption(option);
            }
        }
    }

    public InternalKieModule.CompilationCache getCompilationCache() {
        return this.compilationCache;
    }

    public void setCompilationCache(InternalKieModule.CompilationCache cache) {
        this.compilationCache = cache;
    }

    public boolean isPreCompiled() {
        return this.compilationCache != null;
    }
}

