/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.WindowDeclaration;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.processors.AbstractPackageCompilationPhase;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.ast.descr.WindowDeclarationDescr;
import org.drools.drl.parser.DroolsError;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class WindowDeclarationCompilationPhase
extends AbstractPackageCompilationPhase {
    private final TypeDeclarationContext kBuilder;

    public WindowDeclarationCompilationPhase(PackageRegistry pkgRegistry, PackageDescr packageDescr, TypeDeclarationContext kBuilder) {
        super(pkgRegistry, packageDescr);
        this.kBuilder = kBuilder;
    }

    @Override
    public void process() {
        for (WindowDeclarationDescr wd : this.packageDescr.getWindowDeclarations()) {
            Pattern pattern;
            WindowDeclaration window = new WindowDeclaration(wd.getName(), this.packageDescr.getName());
            InternalKnowledgePackage pkg = this.pkgRegistry.getPackage();
            DialectCompiletimeRegistry ctr = this.pkgRegistry.getDialectCompiletimeRegistry();
            RuleDescr dummy = new RuleDescr(wd.getName() + " Window Declaration");
            dummy.setResource(this.packageDescr.getResource());
            dummy.addAttribute(new AttributeDescr("dialect", "java"));
            RuleBuildContext context = new RuleBuildContext(this.kBuilder, dummy, ctr, pkg, ctr.getDialect(this.pkgRegistry.getDialect()));
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(wd.getPattern().getClass());
            if (builder != null) {
                pattern = (Pattern)builder.build(context, wd.getPattern(), null);
                if (pattern.getXpathConstraint() != null) {
                    context.addError(new DescrBuildError((BaseDescr)wd, context.getParentDescr(), null, "OOpath expression " + pattern.getXpathConstraint() + " not allowed in window declaration\n"));
                }
            } else {
                throw new RuntimeException("BUG: assembler not found for descriptor class " + wd.getPattern().getClass());
            }
            window.setPattern(pattern);
            if (!context.getErrors().isEmpty()) {
                for (DroolsError error : context.getErrors()) {
                    this.results.add((KnowledgeBuilderResult)error);
                }
                continue;
            }
            this.pkgRegistry.getPackage().addWindowDeclaration(window);
        }
    }
}

