/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorCache;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;

public class MatchesEvaluatorsDefinition
implements EvaluatorDefinition {
    public static final Operator MATCHES = Operator.addOperatorToRegistry("matches", false);
    public static final Operator NOT_MATCHES = Operator.addOperatorToRegistry("matches", true);
    private static final String[] SUPPORTED_IDS = new String[]{MATCHES.getOperatorString()};
    private EvaluatorCache evaluators = new EvaluatorCache(){
        private static final long serialVersionUID = 510L;
        {
            this.addEvaluator(ValueType.STRING_TYPE, MATCHES, StringMatchesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, MATCHES, StringMatchesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.STRING_TYPE, NOT_MATCHES, StringNotMatchesEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, NOT_MATCHES, StringNotMatchesEvaluator.INSTANCE);
        }
    };

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator(operatorId, isNegated));
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    public static class StringNotMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringNotMatchesEvaluator();

        public StringNotMatchesEvaluator() {
            super(ValueType.STRING_TYPE, NOT_MATCHES);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            String value1 = (String)extractor.getValue(workingMemory, object1);
            String value2 = (String)object2.getValue();
            if (value1 == null) {
                return false;
            }
            return !value1.matches(value2);
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return !value.matches((String)context.declaration.getExtractor().getValue(workingMemory, left));
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            String value = (String)context.extractor.getValue(workingMemory, right);
            if (value == null) {
                return false;
            }
            return !value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return false;
            }
            return !((String)value1).matches((String)value2);
        }

        @Override
        public String toString() {
            return "String not matches";
        }
    }

    public static class StringMatchesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 400L;
        public static final Evaluator INSTANCE = new StringMatchesEvaluator();

        public StringMatchesEvaluator() {
            super(ValueType.STRING_TYPE, MATCHES);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, Object object1, FieldValue object2) {
            String value1 = (String)extractor.getValue(workingMemory, object1);
            String value2 = (String)object2.getValue();
            if (value1 == null) {
                return false;
            }
            return value1.matches(value2);
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            if (value == null) {
                return false;
            }
            return value.matches((String)context.declaration.getExtractor().getValue(workingMemory, left));
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, Object right) {
            String value = (String)context.extractor.getValue(workingMemory, right);
            if (value == null) {
                return false;
            }
            return value.matches((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return false;
            }
            return ((String)value1).matches((String)value2);
        }

        @Override
        public String toString() {
            return "String matches";
        }
    }
}

