/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefsystem.simple;

import org.drools.beliefsystem.BeliefSet;
import org.drools.beliefsystem.BeliefSystem;
import org.drools.beliefsystem.simple.SimpleBeliefSet;
import org.drools.common.InternalFactHandle;
import org.drools.common.LogicalDependency;
import org.drools.common.NamedEntryPoint;
import org.drools.common.SimpleLogicalDependency;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.core.util.LinkedListEntry;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;

public class SimpleBeliefSystem
implements BeliefSystem {
    private NamedEntryPoint ep;
    private TruthMaintenanceSystem tms;

    public SimpleBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    @Override
    public void insert(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean empty = beliefSet.isEmpty();
        beliefSet.add(node.getJustifierEntry());
        if (empty) {
            InternalFactHandle handle = beliefSet.getFactHandle();
            this.ep.insert(handle, handle.getObject(), node.getJustifier().getRule(), node.getJustifier(), typeConf);
        }
    }

    @Override
    public void read(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        beliefSet.add(node.getJustifierEntry());
    }

    @Override
    public void delete(LogicalDependency node, BeliefSet beliefSet, PropagationContext context) {
        SimpleBeliefSet sBeliefSet = (SimpleBeliefSet)beliefSet;
        beliefSet.remove(node.getJustifierEntry());
        InternalFactHandle bfh = beliefSet.getFactHandle();
        if (beliefSet.isEmpty() && (context.getType() != 1 && context.getType() != 2 || context.getFactHandle() != bfh)) {
            if (sBeliefSet.getWorkingMemoryAction() == null) {
                TruthMaintenanceSystem.LogicalCallback action = new TruthMaintenanceSystem.LogicalCallback(bfh, context, node.getJustifier(), false, true);
                this.ep.enQueueWorkingMemoryAction(action);
                sBeliefSet.setWorkingMemoryAction(action);
            } else {
                TruthMaintenanceSystem.LogicalCallback callback = (TruthMaintenanceSystem.LogicalCallback)sBeliefSet.getWorkingMemoryAction();
                callback.setUpdate(false);
                callback.setFullyRetract(true);
            }
        } else if (!beliefSet.isEmpty() && beliefSet.getFactHandle().getObject() == node.getObject()) {
            ((NamedEntryPoint)bfh.getEntryPoint()).getObjectStore().updateHandle(bfh, ((LogicalDependency)((LinkedListEntry)beliefSet.getFirst()).getObject()).getObject());
            if (sBeliefSet.getWorkingMemoryAction() == null) {
                TruthMaintenanceSystem.LogicalCallback action = new TruthMaintenanceSystem.LogicalCallback(bfh, context, node.getJustifier(), true, false);
                this.ep.enQueueWorkingMemoryAction(action);
                sBeliefSet.setWorkingMemoryAction(action);
            }
        }
    }

    @Override
    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new SimpleBeliefSet(this, fh);
    }

    @Override
    public LogicalDependency newLogicalDependency(Activation activation, BeliefSet beliefSet, Object object, Object value) {
        return new SimpleLogicalDependency(activation, beliefSet, object, value);
    }
}

