/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.reteoo.RightTuple;

public class StagedRightTuples {
    private RightTuple insertFirst;
    private int insertSize;
    private RightTuple deleteFirst;
    private RightTuple updateFirst;

    public RightTuple getInsertFirst() {
        return this.insertFirst;
    }

    public RightTuple getDeleteFirst() {
        return this.deleteFirst;
    }

    public RightTuple getUpdateFirst() {
        return this.updateFirst;
    }

    public void setInsert(RightTuple rightTuple, int size) {
        this.insertFirst = rightTuple;
        this.insertSize = size;
    }

    public void setDelete(RightTuple rightTuple) {
        this.deleteFirst = rightTuple;
    }

    public void setUpdate(RightTuple rightTuple) {
        this.updateFirst = rightTuple;
    }

    public void addInsert(RightTuple rightTuple) {
        rightTuple.setStagedType((short)1);
        if (this.insertFirst == null) {
            this.insertFirst = rightTuple;
        } else {
            rightTuple.setStagedNext(this.insertFirst);
            this.insertFirst.setStagePrevious(rightTuple);
            this.insertFirst = rightTuple;
        }
        ++this.insertSize;
    }

    public void removeInsert(RightTuple rightTuple) {
        rightTuple.setStagedType((short)0);
        if (rightTuple == this.insertFirst) {
            RightTuple next = rightTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.insertFirst = next;
        } else {
            RightTuple next = rightTuple.getStagedNext();
            RightTuple previous = rightTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        --this.insertSize;
        rightTuple.clearStaged();
    }

    public void splitInsert(RightTuple rightTuple, int count) {
        this.insertFirst = rightTuple;
        rightTuple.setStagePrevious(null);
        this.insertSize -= count;
    }

    public int insertSize() {
        return this.insertSize;
    }

    public void addDelete(RightTuple rightTuple) {
        rightTuple.setStagedType((short)3);
        if (this.deleteFirst == null) {
            this.deleteFirst = rightTuple;
        } else {
            rightTuple.setStagedNext(this.deleteFirst);
            this.deleteFirst.setStagePrevious(rightTuple);
            this.deleteFirst = rightTuple;
        }
    }

    public void removeDelete(RightTuple rightTuple) {
        rightTuple.setStagedType((short)0);
        if (rightTuple == this.deleteFirst) {
            RightTuple next = rightTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.deleteFirst = next;
        } else {
            RightTuple next = rightTuple.getStagedNext();
            RightTuple previous = rightTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        rightTuple.clearStaged();
    }

    public void addUpdate(RightTuple rightTuple) {
        rightTuple.setStagedType((short)2);
        if (this.updateFirst == null) {
            this.updateFirst = rightTuple;
        } else {
            rightTuple.setStagedNext(this.updateFirst);
            this.updateFirst.setStagePrevious(rightTuple);
            this.updateFirst = rightTuple;
        }
    }

    public void removeUpdate(RightTuple rightTuple) {
        rightTuple.setStagedType((short)0);
        if (rightTuple == this.updateFirst) {
            RightTuple next = rightTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.updateFirst = next;
        } else {
            RightTuple next = rightTuple.getStagedNext();
            RightTuple previous = rightTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        rightTuple.clearStaged();
    }

    public void clear() {
        RightTuple next;
        RightTuple rightTuple = this.getInsertFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rightTuple.clearStaged();
            rightTuple = next;
        }
        this.setInsert(null, 0);
        rightTuple = this.getDeleteFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rightTuple.clearStaged();
            rightTuple = next;
        }
        this.setDelete(null);
        rightTuple = this.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rightTuple.clearStaged();
            rightTuple = next;
        }
        this.setUpdate(null);
    }

    public String toString() {
        RightTuple rightTuple;
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Inserted:\n");
        for (rightTuple = this.getInsertFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            sbuilder.append(rightTuple + "\n");
        }
        sbuilder.append("Deleted:\n");
        for (rightTuple = this.getDeleteFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            sbuilder.append(rightTuple + "\n");
        }
        sbuilder.append("Updated:\n");
        for (rightTuple = this.getUpdateFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            sbuilder.append(rightTuple + "\n");
        }
        return sbuilder.toString();
    }
}

