/*
 * Decompiled with CFR 0.152.
 */
package org.drools.osgi.core;

import java.util.Hashtable;
import org.drools.impl.KnowledgeBaseFactoryServiceImpl;
import org.drools.io.impl.ResourceFactoryServiceImpl;
import org.drools.marshalling.impl.MarshallerProviderImpl;
import org.kie.KnowledgeBaseFactoryService;
import org.kie.Service;
import org.kie.io.KieResources;
import org.kie.marshalling.KieMarshallers;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    protected static final transient Logger logger = LoggerFactory.getLogger(Activator.class);
    private ServiceRegistration resourceReg;
    private ServiceRegistration kbaseReg;
    private ServiceRegistration marshallerProviderReg;

    public void start(BundleContext bc) throws Exception {
        logger.info("registering core  services");
        this.resourceReg = bc.registerService(new String[]{KieResources.class.getName(), Service.class.getName()}, (Object)new ResourceFactoryServiceImpl(), new Hashtable());
        this.kbaseReg = bc.registerService(new String[]{KnowledgeBaseFactoryService.class.getName(), Service.class.getName()}, (Object)new KnowledgeBaseFactoryServiceImpl(), new Hashtable());
        this.marshallerProviderReg = bc.registerService(new String[]{KieMarshallers.class.getName(), Service.class.getName()}, (Object)new MarshallerProviderImpl(), new Hashtable());
        logger.info("core services registered");
    }

    public void stop(BundleContext bc) throws Exception {
        this.kbaseReg.unregister();
        this.resourceReg.unregister();
        this.marshallerProviderReg.unregister();
    }
}

