/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import org.drools.WorkingMemory;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELObjectExpression;
import org.drools.common.AgendaItem;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.ScheduledAgendaItem;
import org.drools.spi.Activation;
import org.drools.time.TimeUtils;
import org.drools.time.Trigger;
import org.drools.time.impl.DefaultJobHandle;
import org.drools.time.impl.IntervalTrigger;
import org.drools.time.impl.Timer;
import org.kie.runtime.Calendars;

public class ExpressionIntervalTimer
implements Timer,
Externalizable {
    private Date startTime;
    private Date endTime;
    private int repeatLimit;
    private MVELObjectExpression delay;
    private MVELObjectExpression period;

    public ExpressionIntervalTimer() {
    }

    public ExpressionIntervalTimer(Date startTime, Date endTime, int repeatLimit, MVELObjectExpression delay, MVELObjectExpression period) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.repeatLimit = repeatLimit;
        this.delay = delay;
        this.period = period;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.startTime);
        out.writeObject(this.endTime);
        out.writeInt(this.repeatLimit);
        out.writeObject(this.delay);
        out.writeObject(this.period);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.startTime = (Date)in.readObject();
        this.endTime = (Date)in.readObject();
        this.repeatLimit = in.readInt();
        this.delay = (MVELObjectExpression)in.readObject();
        this.period = (MVELObjectExpression)in.readObject();
    }

    public MVELCompilationUnit getDelayMVELCompilationUnit() {
        return this.delay.getMVELCompilationUnit();
    }

    public MVELCompilationUnit getPeriodMVELCompilationUnit() {
        return this.period.getMVELCompilationUnit();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public MVELObjectExpression getDelay() {
        return this.delay;
    }

    public MVELObjectExpression getPeriod() {
        return this.period;
    }

    @Override
    public Trigger createTrigger(Activation item, WorkingMemory wm) {
        long newDelay;
        DefaultJobHandle jh;
        IntervalTrigger preTrig;
        long timestamp = ((InternalWorkingMemory)wm).getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = ((InternalWorkingMemory)wm).getCalendars();
        long timeSinceLastFire = 0L;
        ScheduledAgendaItem schItem = (ScheduledAgendaItem)item;
        if (schItem.getJobHandle() != null && (preTrig = (IntervalTrigger)(jh = (DefaultJobHandle)schItem.getJobHandle()).getTimerJobInstance().getTrigger()).hasNextFireTime() != null) {
            timeSinceLastFire = timestamp - preTrig.getLastFireTime().getTime();
        }
        if ((newDelay = (this.delay != null ? this.evalDelay(item, wm) : 0L) - timeSinceLastFire) < 0L) {
            newDelay = 0L;
        }
        return new IntervalTrigger(timestamp, this.startTime, this.endTime, this.repeatLimit, newDelay, this.period != null ? this.evalPeriod(item, wm) : 0L, calendarNames, calendars);
    }

    private long evalPeriod(Activation item, WorkingMemory wm) {
        Object p = this.period.getValue(item, ((AgendaItem)item).getRuleTerminalNode().getTimerPeriodDeclarations(), item.getRule(), wm);
        if (p instanceof Number) {
            return ((Number)p).longValue();
        }
        return TimeUtils.parseTimeString(p.toString());
    }

    private long evalDelay(Activation item, WorkingMemory wm) {
        Object d = this.delay.getValue(item, ((AgendaItem)item).getRuleTerminalNode().getTimerDelayDeclarations(), item.getRule(), wm);
        if (d instanceof Number) {
            return ((Number)d).longValue();
        }
        return TimeUtils.parseTimeString(d.toString());
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new IntervalTrigger(timestamp, this.startTime, this.endTime, this.repeatLimit, 0L, 0L, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delay.hashCode();
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + this.period.hashCode();
        result = 31 * result + this.repeatLimit;
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionIntervalTimer other = (ExpressionIntervalTimer)obj;
        if (this.delay != other.delay) {
            return false;
        }
        if (this.repeatLimit != other.repeatLimit) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        return !(this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime));
    }
}

