/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.command.IdentifiableResult;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.core.util.StringUtils;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.xml.jaxb.util.JaxbCollectionAdapter;
import org.kie.command.Context;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.rule.FactHandle;

@XmlAccessorType(value=XmlAccessType.NONE)
public class InsertElementsCommand
implements GenericCommand<Collection<FactHandle>>,
IdentifiableResult {
    private static final long serialVersionUID = 510L;
    @XmlJavaTypeAdapter(value=JaxbCollectionAdapter.class)
    @XmlElement(name="list")
    public Collection<Object> objects;
    @XmlAttribute
    private String outIdentifier;
    @XmlAttribute(name="return-objects")
    private boolean returnObject = true;
    @XmlAttribute(name="entry-point")
    private String entryPoint;

    public InsertElementsCommand() {
        this.objects = new ArrayList<Object>();
    }

    public InsertElementsCommand(Collection<Object> objects) {
        this.objects = objects;
    }

    public InsertElementsCommand(String outIdentifier) {
        this();
        this.outIdentifier = outIdentifier;
    }

    public Collection<Object> getObjects() {
        return this.objects;
    }

    public void setObjects(List<Object> objects) {
        this.objects = objects;
    }

    @Override
    public Collection<FactHandle> execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        Object wmep = StringUtils.isEmpty(this.entryPoint) ? ksession : ksession.getWorkingMemoryEntryPoint(this.entryPoint);
        for (Object object : this.objects) {
            handles.add(wmep.insert(object));
        }
        if (this.outIdentifier != null) {
            if (this.returnObject) {
                ((StatefulKnowledgeSessionImpl)ksession).session.getExecutionResult().getResults().put(this.outIdentifier, this.objects);
            }
            ((StatefulKnowledgeSessionImpl)ksession).session.getExecutionResult().getFactHandles().put(this.outIdentifier, handles);
        }
        return handles;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public boolean isReturnObject() {
        return this.returnObject;
    }

    public void setReturnObject(boolean returnObject) {
        this.returnObject = returnObject;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public String toString() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : this.objects) {
            list.add(object);
        }
        return "insert " + list;
    }
}

