/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BetaConstraints;
import org.drools.core.util.index.IndexUtil;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.ContextEntry;
import org.drools.spi.BetaNodeFieldConstraint;
import org.kie.conf.IndexPrecedenceOption;

public abstract class MultipleBetaConstraint
implements BetaConstraints {
    protected BetaNodeFieldConstraint[] constraints;
    protected boolean[] indexed;
    private IndexPrecedenceOption indexPrecedenceOption;
    private transient boolean disableIndexing;

    public MultipleBetaConstraint() {
    }

    public MultipleBetaConstraint(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf, boolean disableIndexing) {
        this.constraints = constraints;
        this.disableIndexing = disableIndexing;
        this.indexPrecedenceOption = conf.getIndexPrecedenceOption();
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (BetaNodeFieldConstraint[])in.readObject();
        this.indexed = (boolean[])in.readObject();
        this.indexPrecedenceOption = (IndexPrecedenceOption)in.readObject();
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraints);
        out.writeObject(this.indexed);
        out.writeObject(this.indexPrecedenceOption);
    }

    @Override
    public final void init(BuildContext context, short betaNodeType) {
        RuleBaseConfiguration config = context.getRuleBase().getConfiguration();
        if (this.disableIndexing || !config.isIndexLeftBetaMemory() && !config.isIndexRightBetaMemory()) {
            this.indexed = new boolean[this.constraints.length];
        } else {
            int depth = config.getCompositeKeyDepth();
            if (!IndexUtil.compositeAllowed(this.constraints, betaNodeType)) {
                depth = 1;
            }
            this.initIndexes(depth, betaNodeType);
        }
    }

    @Override
    public final void initIndexes(int depth, short betaNodeType) {
        this.indexed = IndexUtil.isIndexableForNode(this.indexPrecedenceOption, betaNodeType, depth, this.constraints);
    }

    @Override
    public final boolean isIndexed() {
        return this.indexed[0];
    }

    @Override
    public final int getIndexCount() {
        int count = 0;
        for (boolean i : this.indexed) {
            if (!i) continue;
            ++count;
        }
        return count;
    }

    @Override
    public BetaMemory createBetaMemory(RuleBaseConfiguration config, short nodeType) {
        return IndexUtil.Factory.createBetaMemory(config, nodeType, this.constraints);
    }

    @Override
    public final BetaNodeFieldConstraint[] getConstraints() {
        return this.constraints;
    }

    @Override
    public final ContextEntry[] createContext() {
        ContextEntry[] entries = new ContextEntry[this.constraints.length];
        for (int i = 0; i < this.constraints.length; ++i) {
            entries[i] = this.constraints[i].createContextEntry();
        }
        return entries;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }
}

