/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.debug;

import java.util.Stack;
import org.drools.common.NetworkNode;
import org.drools.core.util.FastIterator;
import org.drools.core.util.debug.AbstractNetworkNodeVisitor;
import org.drools.core.util.debug.DefaultNodeInfo;
import org.drools.core.util.debug.StatefulKnowledgeSessionInfo;
import org.drools.reteoo.AccumulateNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;

public class AccumulateNodeVisitor
extends AbstractNetworkNodeVisitor {
    public static final AccumulateNodeVisitor INSTANCE = new AccumulateNodeVisitor();

    protected AccumulateNodeVisitor() {
    }

    @Override
    protected void doVisit(NetworkNode node, Stack<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        AccumulateNode an = (AccumulateNode)node;
        DefaultNodeInfo ni = info.getNodeInfo(node);
        AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)info.getSession().getNodeMemory(an);
        ni.setMemoryEnabled(true);
        if (an.isObjectMemoryEnabled()) {
            ni.setFactMemorySize(memory.betaMemory.getRightTupleMemory().size());
        }
        if (an.isLeftTupleMemoryEnabled()) {
            ni.setTupleMemorySize(memory.betaMemory.getLeftTupleMemory().size());
            FastIterator it = memory.betaMemory.getLeftTupleMemory().fullFastIterator();
            int i = 0;
            LeftTuple leftTuple = BetaNode.getFirstLeftTuple(memory.betaMemory.getLeftTupleMemory(), it);
            while (leftTuple != null) {
                AccumulateNode.AccumulateContext ctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                if (ctx != null && ctx.result != null) {
                    ++i;
                }
                leftTuple = (LeftTuple)it.next(leftTuple);
            }
            ni.setCreatedFactHandles(i);
        }
    }
}

