/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LeftTupleIterator;
import org.drools.common.PropagationContextImpl;
import org.drools.common.UpdateContext;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.spi.PropagationContext;

public class QueryRiaFixerNode
extends LeftTupleSource
implements LeftTupleSinkNode {
    private static final long serialVersionUID = 510L;
    protected boolean tupleMemoryEnabled;
    private BetaNode betaNode;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public QueryRiaFixerNode() {
    }

    public QueryRiaFixerNode(int id, LeftTupleSource tupleSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.setLeftTupleSource(tupleSource);
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.betaNode = (BetaNode)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.betaNode);
        out.writeBoolean(this.tupleMemoryEnabled);
    }

    public BetaNode getBetaNode() {
        return this.betaNode;
    }

    @Override
    public void addTupleSink(LeftTupleSink tupleSink, BuildContext context) {
        this.betaNode = (BetaNode)tupleSink;
    }

    @Override
    public void attach(BuildContext context) {
        this.leftInput.addTupleSink(this, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.leftInput.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        context.getQueue2().addLast(new ReteooWorkingMemory.QueryRiaFixerNodeFixer(context, leftTuple, false, this.betaNode));
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        context.getQueue2().addLast(new ReteooWorkingMemory.QueryRiaFixerNodeFixer(context, leftTuple, true, this.betaNode));
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        context.getQueue2().addLast(new ReteooWorkingMemory.QueryRiaFixerNodeFixer(context, leftTuple, false, this.betaNode));
    }

    @Override
    public String toString() {
        return "[RiaQueryFixerNode: ]";
    }

    @Override
    public int hashCode() {
        return this.leftInput.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleIterator it = LeftTupleIterator.iterator(workingMemory, this);
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightParent, childLeftTuple, null, sink, true), context, workingMemory);
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            leftTuple = (LeftTuple)it.next();
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        this.leftInput.remove(context, builder, this, workingMemories);
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 141;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return this.betaNode.createLeftTuple(factHandle, (LeftTupleSink)this.betaNode, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return this.betaNode.createLeftTuple(leftTuple, (LeftTupleSink)this.betaNode, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return this.betaNode.createLeftTuple(leftTuple, rightTuple, this.betaNode);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return this.betaNode.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, this.betaNode, leftTupleMemoryEnabled);
    }

    @Override
    public boolean isInUse() {
        return this.betaNode != null;
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        return null;
    }
}

