/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time;

import java.util.List;
import org.drools.rule.Pattern;
import org.drools.time.Interval;

public class TemporalDependencyMatrix {
    private Interval[][] matrix;
    private List<Pattern> events;

    public TemporalDependencyMatrix(Interval[][] matrix, List<Pattern> events) {
        this.matrix = matrix;
        this.events = events;
    }

    public Interval[][] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Interval[][] matrix) {
        this.matrix = matrix;
    }

    public List<Pattern> getEvents() {
        return this.events;
    }

    public void setEvents(List<Pattern> events) {
        this.events = events;
    }

    public long getExpirationOffset(Pattern pattern) {
        long expiration = 0L;
        int index = this.events.indexOf(pattern);
        for (Interval interval : this.matrix[index]) {
            expiration = Math.max(expiration, interval.getUpperBound());
        }
        if (expiration == 0L) {
            expiration = -1L;
        } else if (expiration != Long.MAX_VALUE) {
            ++expiration;
        }
        return expiration;
    }
}

