/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.RuntimeDroolsException;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.MathUtils;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.spi.InternalReadAccessor;

public abstract class BaseClassFieldReader
implements InternalReadAccessor {
    private int index;
    private Class<?> fieldType;
    private ValueType valueType;

    public BaseClassFieldReader() {
    }

    protected BaseClassFieldReader(int index, Class<?> fieldType, ValueType valueType) {
        this.index = index;
        this.fieldType = fieldType;
        this.valueType = valueType;
    }

    public BaseClassFieldReader(Class<?> clazz, String fieldName) {
        try {
            ClassFieldInspector inspector = new ClassFieldInspector(clazz);
            this.index = inspector.getFieldNames().get(fieldName);
            this.fieldType = inspector.getFieldTypes().get(fieldName);
            this.valueType = ValueType.determineValueType(this.fieldType);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    @Override
    public Class<?> getExtractToClass() {
        return this.fieldType;
    }

    @Override
    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.fieldType);
    }

    public void setFieldType(Class<?> fieldType) {
        this.fieldType = fieldType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean isSelfReference() {
        return false;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.fieldType != null ? this.fieldType.hashCode() : 0);
        result = 31 * result + this.index;
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseClassFieldReader)) {
            return false;
        }
        BaseClassFieldReader other = (BaseClassFieldReader)object;
        return this.fieldType == other.fieldType && this.index == other.index && this.valueType.equals(other.valueType);
    }

    @Override
    public Object getValue(Object object) {
        return this.getValue(null, object);
    }

    @Override
    public char getCharValue(Object object) {
        return this.getCharValue(null, object);
    }

    @Override
    public int getIntValue(Object object) {
        return this.getIntValue(null, object);
    }

    @Override
    public byte getByteValue(Object object) {
        return this.getByteValue(null, object);
    }

    @Override
    public short getShortValue(Object object) {
        return this.getShortValue(null, object);
    }

    @Override
    public long getLongValue(Object object) {
        return this.getLongValue(null, object);
    }

    @Override
    public float getFloatValue(Object object) {
        return this.getFloatValue(null, object);
    }

    @Override
    public double getDoubleValue(Object object) {
        return this.getDoubleValue(null, object);
    }

    @Override
    public boolean getBooleanValue(Object object) {
        return this.getBooleanValue(null, object);
    }

    @Override
    public BigDecimal getBigDecimalValue(Object object) {
        return this.getBigDecimalValue(null, object);
    }

    @Override
    public BigInteger getBigIntegerValue(Object object) {
        return this.getBigIntegerValue(null, object);
    }

    @Override
    public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
        return MathUtils.getBigDecimal(this.getValue(workingMemory, object));
    }

    @Override
    public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
        return MathUtils.getBigInteger(this.getValue(workingMemory, object));
    }

    @Override
    public boolean isNullValue(Object object) {
        return this.isNullValue(null, object);
    }

    @Override
    public int getHashCode(Object object) {
        return this.getHashCode(null, object);
    }
}

