/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.ValueType;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalFactHandle;
import org.drools.spi.Evaluator;
import org.drools.time.Interval;

public abstract class BaseEvaluator
implements Evaluator,
Externalizable {
    private Operator operator;
    private ValueType type;

    public BaseEvaluator() {
    }

    public BaseEvaluator(ValueType type, Operator operator) {
        this.type = type;
        this.operator = operator;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.operator = (Operator)in.readObject();
        this.type = (ValueType)in.readObject();
        if (this.type != null) {
            this.type = ValueType.determineValueType(this.type.getClassType());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.operator);
        out.writeObject(this.type);
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public ValueType getValueType() {
        return this.type;
    }

    @Override
    public ValueType getCoercedValueType() {
        return this.type;
    }

    @Override
    public Object prepareLeftObject(InternalFactHandle handle) {
        return handle.getObject();
    }

    @Override
    public Object prepareRightObject(InternalFactHandle handle) {
        return this.prepareLeftObject(handle);
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public Interval getInterval() {
        return new Interval();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BaseEvaluator)) {
            return false;
        }
        Evaluator other = (Evaluator)object;
        return this.getOperator() == other.getOperator() && this.getValueType() == other.getValueType();
    }

    public int hashCode() {
        return this.getValueType().hashCode() ^ this.getOperator().hashCode() ^ this.getClass().hashCode();
    }

    public String toString() {
        return this.type.getName() + " " + this.operator.toString();
    }
}

