/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.field;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.RuntimeDroolsException;
import org.drools.spi.FieldValue;

public class DoubleFieldImpl
implements FieldValue,
Externalizable {
    private static final long serialVersionUID = 510L;
    private double value;

    public DoubleFieldImpl() {
    }

    public DoubleFieldImpl(double value) {
        this.value = value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readDouble();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public Serializable getValue() {
        return new Double(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean getBooleanValue() {
        throw new RuntimeDroolsException("Conversion to boolean not supported for type double");
    }

    @Override
    public byte getByteValue() {
        return (byte)this.value;
    }

    @Override
    public char getCharValue() {
        return (char)this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public float getFloatValue() {
        return (float)this.value;
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public long getLongValue() {
        return (long)this.value;
    }

    @Override
    public short getShortValue() {
        return (short)this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DoubleFieldImpl)) {
            return false;
        }
        DoubleFieldImpl other = (DoubleFieldImpl)object;
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isBooleanField() {
        return false;
    }

    @Override
    public boolean isFloatNumberField() {
        return true;
    }

    @Override
    public boolean isIntegerNumberField() {
        return false;
    }

    @Override
    public boolean isObjectField() {
        return false;
    }

    @Override
    public boolean isCollectionField() {
        return false;
    }

    @Override
    public boolean isStringField() {
        return false;
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        return new BigDecimal(this.value);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return new BigDecimal(this.value).toBigInteger();
    }
}

