/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.common.InternalRuleBase;
import org.drools.common.Memory;
import org.drools.common.MemoryFactory;
import org.drools.common.NodeMemories;

public class ConcurrentNodeMemories
implements NodeMemories {
    private AtomicReferenceArray<Memory> memories;
    private Lock lock;
    private InternalRuleBase rulebase;

    public ConcurrentNodeMemories(InternalRuleBase rulebase) {
        this.rulebase = rulebase;
        this.memories = new AtomicReferenceArray(this.rulebase.getNodeCount());
        this.lock = new ReentrantLock();
    }

    @Override
    public void clearNodeMemory(MemoryFactory node) {
        this.memories.set(node.getId(), null);
    }

    @Override
    public void clear() {
        this.memories = new AtomicReferenceArray(this.rulebase.getNodeCount());
    }

    @Override
    public Memory getNodeMemory(MemoryFactory node) {
        Memory memory;
        if (node.getId() >= this.memories.length()) {
            this.resize(node);
        }
        if ((memory = this.memories.get(node.getId())) == null) {
            memory = this.createNodeMemory(node);
        }
        return memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Memory createNodeMemory(MemoryFactory node) {
        try {
            this.lock.lock();
            Memory memory = this.memories.get(node.getId());
            if (memory == null) {
                memory = node.createMemory(this.rulebase.getConfiguration());
                if (!this.memories.compareAndSet(node.getId(), null, memory)) {
                    memory = this.memories.get(node.getId());
                }
            }
            Memory memory2 = memory;
            return memory2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resize(MemoryFactory node) {
        try {
            this.lock.lock();
            if (node.getId() >= this.memories.length()) {
                int size = Math.max(this.rulebase.getNodeCount(), node.getId() + 32);
                AtomicReferenceArray<Memory> newMem = new AtomicReferenceArray<Memory>(size);
                for (int i = 0; i < this.memories.length(); ++i) {
                    newMem.set(i, this.memories.get(i));
                }
                this.memories = newMem;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setRuleBaseReference(InternalRuleBase ruleBase) {
        this.rulebase = ruleBase;
    }

    @Override
    public Memory peekNodeMemory(int nodeId) {
        return this.memories.get(nodeId);
    }

    @Override
    public int length() {
        return this.memories.length();
    }
}

