/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.reteoo.LeftTuple;

public class StagedLeftTuples {
    private LeftTuple insertFirst;
    private int insertSize;
    private LeftTuple deleteFirst;
    private LeftTuple updateFirst;

    public LeftTuple getInsertFirst() {
        return this.insertFirst;
    }

    public LeftTuple getDeleteFirst() {
        return this.deleteFirst;
    }

    public LeftTuple getUpdateFirst() {
        return this.updateFirst;
    }

    public void setInsert(LeftTuple leftTuple, int size) {
        this.insertFirst = leftTuple;
        this.insertSize = size;
    }

    public void setDelete(LeftTuple leftTuple) {
        this.deleteFirst = leftTuple;
    }

    public void setUpdate(LeftTuple leftTuple) {
        this.updateFirst = leftTuple;
    }

    public void addAllInserts(LeftTuple leftTuple) {
        if (this.insertFirst == null) {
            this.insertFirst = leftTuple;
        } else {
            LeftTuple last = null;
            for (LeftTuple current = this.insertFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            last.setStagedNext(leftTuple);
            leftTuple.setStagePrevious(leftTuple);
        }
    }

    public void addInsert(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)1);
        if (this.insertFirst == null) {
            this.insertFirst = leftTuple;
        } else {
            leftTuple.setStagedNext(this.insertFirst);
            this.insertFirst.setStagePrevious(leftTuple);
            this.insertFirst = leftTuple;
        }
        ++this.insertSize;
    }

    public void removeInsert(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.insertFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.insertFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        --this.insertSize;
        leftTuple.clearStaged();
    }

    public void splitInsert(LeftTuple leftTuple, int count) {
        this.insertFirst = leftTuple;
        leftTuple.setStagePrevious(null);
        this.insertSize -= count;
    }

    public int insertSize() {
        return this.insertSize;
    }

    public void addAllDeletes(LeftTuple leftTuple) {
        if (this.deleteFirst == null) {
            this.deleteFirst = leftTuple;
        } else {
            LeftTuple last = null;
            for (LeftTuple current = this.deleteFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            last.setStagedNext(leftTuple);
            leftTuple.setStagePrevious(leftTuple);
        }
    }

    public void addDelete(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)3);
        if (this.deleteFirst == null) {
            this.deleteFirst = leftTuple;
        } else {
            leftTuple.setStagedNext(this.deleteFirst);
            this.deleteFirst.setStagePrevious(leftTuple);
            this.deleteFirst = leftTuple;
        }
    }

    public void removeDelete(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.deleteFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.deleteFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        leftTuple.clearStaged();
    }

    public void addAllUpdates(LeftTuple leftTuple) {
        if (this.updateFirst == null) {
            this.updateFirst = leftTuple;
        } else {
            LeftTuple last = null;
            for (LeftTuple current = this.updateFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            last.setStagedNext(leftTuple);
            leftTuple.setStagePrevious(leftTuple);
        }
    }

    public void addUpdate(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)2);
        if (this.updateFirst == null) {
            this.updateFirst = leftTuple;
        } else {
            leftTuple.setStagedNext(this.updateFirst);
            this.updateFirst.setStagePrevious(leftTuple);
            this.updateFirst = leftTuple;
        }
    }

    public void removeUpdate(LeftTuple leftTuple) {
        leftTuple.setStagedType((short)0);
        if (leftTuple == this.updateFirst) {
            LeftTuple next = leftTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.updateFirst = next;
        } else {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple previous = leftTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        leftTuple.clearStaged();
    }

    public void clear() {
        LeftTuple next;
        LeftTuple leftTuple = this.getInsertFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
        this.setInsert(null, 0);
        leftTuple = this.getDeleteFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
        this.setDelete(null);
        leftTuple = this.getUpdateFirst();
        while (leftTuple != null) {
            next = leftTuple.getStagedNext();
            leftTuple.clearStaged();
            leftTuple = next;
        }
        this.setUpdate(null);
    }

    public void merge(StagedLeftTuples source) {
        this.addAllInserts(source.getInsertFirst());
        this.addAllDeletes(source.getDeleteFirst());
        this.addAllUpdates(source.getUpdateFirst());
    }

    public String toString() {
        LeftTuple leftTuple;
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Inserted:\n");
        for (leftTuple = this.getInsertFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            sbuilder.append(leftTuple + "\n");
        }
        sbuilder.append("Deleted:\n");
        for (leftTuple = this.getDeleteFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            sbuilder.append(leftTuple + "\n");
        }
        sbuilder.append("Updated:\n");
        for (leftTuple = this.getUpdateFirst(); leftTuple != null; leftTuple = leftTuple.getStagedNext()) {
            sbuilder.append(leftTuple + "\n");
        }
        return sbuilder.toString();
    }
}

